/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.activecomponents.webservice.AbstractWebSocketServer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class JettyWebsocketServer {
    protected AbstractWebSocketServer server;
    protected Map<Session, Map<String, Object>> props = new HashMap<Session, Map<String, Object>>();

    public JettyWebsocketServer(IInternalAccess agent) {
        this.server = new AbstractWebSocketServer((IExternalAccess)agent){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sendWebSocketData(Object ws, String data) {
                try {
                    Object object = ws;
                    synchronized (object) {
                        Session session = (Session)ws;
                        session.getRemote().sendString(data);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public Map<String, Object> getSessionProperties(Object ws) {
                Session session = (Session)ws;
                return JettyWebsocketServer.this.getUserProperties(session);
            }
        };
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        System.out.println("Websocket session started: " + session);
    }

    @OnWebSocketMessage
    public void onText(Session session, String message) {
        this.server.onMessage((Object)session, message);
    }

    @OnWebSocketClose
    public void onClose(Session session, int status, String reason) {
        this.server.onClose((Object)session);
    }

    @OnWebSocketError
    public void onError(Throwable error) {
        System.out.println("Websocket error: " + error);
    }

    public Map<String, Object> getUserProperties(Session session) {
        Map<String, Object> ret = this.props.get(session);
        if (ret == null) {
            ret = new HashMap<String, Object>();
            this.props.put(session, ret);
        }
        return ret;
    }
}

