/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.commons.Tuple2;
import jadex.extension.rs.publish.HttpServletRequestWrapper;
import jadex.extension.rs.publish.IPathHandler;
import jadex.extension.rs.publish.IRequestHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

public class PathHandler
implements IPathHandler {
    protected Map<Tuple2<String, String>, Tuple2<String, IRequestHandler>> subhandlers = new HashMap<Tuple2<String, String>, Tuple2<String, IRequestHandler>>();
    protected Map<Tuple2<String, String>, Tuple2<String, IRequestHandler>> subhandlercache = new HashMap<Tuple2<String, String>, Tuple2<String, IRequestHandler>>();

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response, Object args) throws Exception {
        Tuple2<String, IRequestHandler> tup;
        int idx;
        String host;
        String path = request.getRequestURI();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((host = request.getHeader("host")) != null && (idx = host.indexOf(":")) != -1) {
            host = host.substring(0, idx);
        }
        String pathcp = null;
        String ctx = request.getContextPath();
        if (ctx != null && ctx.length() > 0) {
            pathcp = path.replaceFirst(ctx, "/DEFAULTAPP");
        }
        if ((tup = this.subhandlercache.get(new Tuple2((Object)host, (Object)path))) == null) {
            tup = this.subhandlercache.get(new Tuple2(null, (Object)path));
        }
        if (tup == null && pathcp != null) {
            tup = this.subhandlercache.get(new Tuple2(null, (Object)pathcp));
        }
        int pidx = path.lastIndexOf(47);
        if (tup == null && pidx > 0 && pidx <= path.length() - 1) {
            String cpath = path.substring(0, pidx);
            tup = this.subhandlercache.get(new Tuple2((Object)host, (Object)cpath));
        }
        if (tup == null) {
            tup = this.findSubhandler(host, path);
            if (tup == null) {
                tup = this.findSubhandler(null, path);
            }
            if (tup != null) {
                this.subhandlercache.put((Tuple2<String, String>)new Tuple2((Object)host, (Object)path), tup);
            }
        }
        if (tup == null) {
            if (pathcp != null) {
                tup = this.findSubhandler(null, pathcp);
            }
            if (tup != null) {
                this.subhandlercache.put((Tuple2<String, String>)new Tuple2((Object)host, (Object)pathcp), tup);
            }
        }
        if (tup == null) {
            throw new RuntimeException("No handler found for path: " + path);
        }
        HttpServletRequestWrapper wr = new HttpServletRequestWrapper(request);
        String cp = (String)tup.getFirstEntity();
        if (cp.startsWith("/DEFAULTAPP")) {
            cp = cp.replaceFirst("/DEFAULTAPP", request.getContextPath());
        }
        wr.setContextPath(cp);
        String full = request.getRequestURI();
        int idx2 = full.indexOf(cp) + cp.length();
        String npi = full.substring(idx2);
        wr.setPathInfo(npi);
        ((IRequestHandler)tup.getSecondEntity()).handleRequest(wr, response, args);
    }

    @Override
    public void addSubhandler(String vhost, String path, IRequestHandler subhandler) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.subhandlers.put((Tuple2<String, String>)new Tuple2((Object)vhost, (Object)path), (Tuple2<String, IRequestHandler>)new Tuple2((Object)path, (Object)subhandler));
        this.subhandlercache = new HashMap<Tuple2<String, String>, Tuple2<String, IRequestHandler>>(this.subhandlers);
    }

    @Override
    public boolean containsSubhandlerForExactUri(String vhost, String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return this.subhandlers.containsKey(new Tuple2((Object)vhost, (Object)path));
    }

    public boolean isEmpty() {
        return this.subhandlers.isEmpty();
    }

    @Override
    public void removeSubhandler(String vhost, String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.subhandlers.remove(new Tuple2((Object)vhost, (Object)path));
        this.subhandlercache = new HashMap<Tuple2<String, String>, Tuple2<String, IRequestHandler>>(this.subhandlers);
    }

    protected Tuple2<String, IRequestHandler> findSubhandler(String host, String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Tuple2<String, IRequestHandler> ret = null;
        do {
            int pidx;
            if ((pidx = path.lastIndexOf(47)) >= 0) {
                path = path.substring(0, pidx);
                ret = this.subhandlercache.get(new Tuple2((Object)host, (Object)path));
                continue;
            }
            path = null;
        } while (ret == null && path != null && path.length() > 0);
        return ret;
    }

    @Override
    public Map<Tuple2<String, String>, Tuple2<String, IRequestHandler>> getSubhandlers() {
        return this.subhandlers;
    }
}

