/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.extension.rs.publish.HttpServletRequestWrapper;
import jadex.extension.rs.publish.IPathHandler;
import jadex.extension.rs.publish.IRequestHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PathHandler2
implements IPathHandler {
    protected Map<Tuple2<String, String>, Tuple2<String, IRequestHandler>> subhandlersold;
    protected List<Map<String, Collection<SubHandler>>> subhandlers = new ArrayList<Map<String, Collection<SubHandler>>>();

    public PathHandler2() {
        this.subhandlersold = new HashMap<Tuple2<String, String>, Tuple2<String, IRequestHandler>>();
    }

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response, Object args) throws Exception {
        SubHandler subhandler;
        int idx;
        String host;
        String path = request.getRequestURI();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((host = request.getHeader("host")) != null && (idx = host.indexOf(":")) != -1) {
            host = host.substring(0, idx);
        }
        String pathcp = null;
        String ctx = request.getContextPath();
        if (ctx != null && ctx.length() > 0) {
            pathcp = path.replaceFirst(ctx, "/DEFAULTAPP");
        }
        SubHandler sh = this.findSubhandler(host, path);
        SubHandler sh2 = this.findSubhandler(host, pathcp);
        SubHandler subHandler = sh == null && sh2 == null ? null : (sh != null && sh2 == null ? sh : (sh2 != null && sh == null ? sh2 : (subhandler = sh.getSpecifity() > sh2.getSpecifity() ? sh : sh2)));
        if (subhandler == null) {
            throw new RuntimeException("No handler found for path: " + path);
        }
        HttpServletRequestWrapper wr = new HttpServletRequestWrapper(request);
        String cp = subhandler.getPath();
        if (cp.startsWith("/DEFAULTAPP")) {
            cp = cp.replaceFirst("/DEFAULTAPP", request.getContextPath());
        }
        wr.setContextPath(cp);
        String full = request.getRequestURI();
        int idx2 = full.indexOf(cp) + cp.length();
        String npi = full.substring(idx2);
        wr.setPathInfo(npi);
        subhandler.getHandler().handleRequest(wr, response, args);
    }

    @Override
    public void addSubhandler(String vhost, String path, IRequestHandler subhandler) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        SubHandler sh = new SubHandler(vhost, path, subhandler);
        StringTokenizer stok = new StringTokenizer(path, "/");
        int i = 0;
        while (stok.hasMoreTokens()) {
            Collection<SubHandler> handlers;
            Map<String, Collection<SubHandler>> hmap;
            String pe = stok.nextToken();
            if (pe.startsWith("{") && pe.endsWith("}")) {
                pe = "*";
            }
            if ((hmap = this.subhandlers.get(i)) == null) {
                hmap = new HashMap<String, Collection<SubHandler>>();
            }
            if ((handlers = hmap.get(pe)) == null) {
                handlers = new ArrayList<SubHandler>();
                hmap.put(pe, handlers);
            }
            handlers.add(sh);
            ++i;
        }
        this.subhandlersold.put((Tuple2<String, String>)new Tuple2((Object)vhost, (Object)path), (Tuple2<String, IRequestHandler>)new Tuple2((Object)path, (Object)subhandler));
    }

    @Override
    public boolean containsSubhandlerForExactUri(String vhost, String path) {
        SubHandler sh;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return (sh = this.findSubhandler(vhost, path)).getSpecifity() == path.length() - path.replace("/", "").length();
    }

    public boolean isEmpty() {
        return this.subhandlers.isEmpty();
    }

    @Override
    public void removeSubhandler(String vhost, String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        SubHandler sh = this.findSubhandler(vhost, path);
        StringTokenizer stok = new StringTokenizer(path, "/");
        int i = 0;
        while (stok.hasMoreTokens()) {
            Collection<SubHandler> col;
            Map<String, Collection<SubHandler>> hmap;
            String pe = stok.nextToken();
            if (pe.startsWith("{") && pe.endsWith("}")) {
                pe = "*";
            }
            if ((hmap = this.subhandlers.get(i)) != null && (col = hmap.get(pe)) != null) {
                for (SubHandler tmp : col) {
                    if (tmp.getHandler().equals(sh.getHandler())) {
                        col.remove(tmp);
                    }
                    if (col.size() != 0) continue;
                    hmap.remove(pe);
                }
            }
            ++i;
        }
        this.subhandlersold.remove(new Tuple2((Object)vhost, (Object)path));
    }

    @Override
    public Map<Tuple2<String, String>, Tuple2<String, IRequestHandler>> getSubhandlers() {
        return this.subhandlersold;
    }

    protected SubHandler findSubhandler(String host, String path) {
        SubHandler ret = null;
        StringTokenizer stok = new StringTokenizer(path, "/");
        HashSet res = null;
        int i = 0;
        while (stok.hasMoreTokens()) {
            String pe = stok.nextToken();
            Map<String, Collection<SubHandler>> hmap = this.subhandlers.get(i);
            Collection shs = SUtil.notNull(hmap.get(pe));
            shs.addAll(SUtil.notNull(hmap.get("*")));
            if (i == 0) {
                res = shs;
            } else {
                HashSet newres = new HashSet(res);
                newres.retainAll(shs);
                if (newres.size() <= 1) break;
                res = newres;
            }
            ++i;
        }
        if (res.size() == 1) {
            ret = (SubHandler)res.iterator().next();
        }
        if (res.size() > 1) {
            int spec = -1;
            for (SubHandler tmp : res) {
                if (tmp.getSpecifity() <= spec) continue;
                ret = tmp;
                spec = tmp.getSpecifity();
            }
        }
        return ret;
    }

    public static class SubHandler {
        protected String vhost;
        protected String path;
        protected IRequestHandler handler;

        public SubHandler(String vhost, String path, IRequestHandler handler) {
            this.vhost = vhost;
            this.path = path;
            this.handler = handler;
        }

        public String getVhost() {
            return this.vhost;
        }

        public void setVhost(String vhost) {
            this.vhost = vhost;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public IRequestHandler getHandler() {
            return this.handler;
        }

        public void setHandler(IRequestHandler handler) {
            this.handler = handler;
        }

        public int getSpecifity() {
            return this.path.length() - this.path.replace("/", "").length();
        }
    }
}

