/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.commons.SUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public class PathManager<T> {
    protected List<Map<String, Collection<T>>> pathparts = new ArrayList<Map<String, Collection<T>>>();
    protected Map<T, String> addedpaths = new HashMap<T, String>();

    public void addPathElement(String path, T elem) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.addedpaths.put(elem, path);
        StringTokenizer stok = new StringTokenizer(path, "/");
        int i = 0;
        while (stok.hasMoreTokens()) {
            Collection<T> handlers;
            Map<String, Collection<T>> hmap;
            String pe = stok.nextToken();
            if (pe.startsWith("{") && pe.endsWith("}")) {
                pe = "*";
            }
            if ((hmap = this.getPathPartMap(i, true)) == null) {
                hmap = new HashMap<String, Collection<T>>();
            }
            if ((handlers = hmap.get(pe)) == null) {
                handlers = new ArrayList<T>();
                hmap.put(pe, handlers);
            }
            handlers.add(elem);
            ++i;
        }
    }

    public T getElementForPath(String path) {
        Collection<T> res = this.getElementsForPath(path);
        return res.size() > 0 ? (T)res.iterator().next() : null;
    }

    public Collection<T> getElementsForPath(String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        StringTokenizer stok = new StringTokenizer(path, "/");
        Collection<Object> res = Collections.EMPTY_LIST;
        int i = 0;
        while (stok.hasMoreTokens()) {
            String pe = stok.nextToken();
            Map<String, Collection<T>> hmap = this.getPathPartMap(i, false);
            Collection<T> shs = hmap.get(pe);
            if (shs == null) {
                shs = new HashSet<T>();
            }
            shs.addAll(SUtil.notNull(hmap.get("*")));
            if (i == 0) {
                res = shs;
            } else {
                HashSet newres = new HashSet(res);
                newres.retainAll(shs);
                if (newres.size() == 0) break;
                res = newres;
            }
            ++i;
        }
        int maxdepth = this.getPathDepth(path);
        res = res.stream().filter(x -> this.getPathDepth(x) <= maxdepth).collect(Collectors.toList());
        Collections.sort(new ArrayList(res), (x, y) -> this.getPathDepth(x) - this.getPathDepth(y));
        return res;
    }

    public void removeElementForPath(String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        T elem = this.getElementForPath(path);
        this.addedpaths.remove(elem);
        StringTokenizer stok = new StringTokenizer(path, "/");
        int i = 0;
        while (stok.hasMoreTokens()) {
            Collection<T> col;
            Map<String, Collection<T>> hmap;
            String pe = stok.nextToken();
            if (pe.startsWith("{") && pe.endsWith("}")) {
                pe = "*";
            }
            if ((hmap = this.getPathPartMap(i, false)) != null && (col = hmap.get(pe)) != null) {
                for (T tmp : col) {
                    if (tmp.equals(elem)) {
                        col.remove(tmp);
                    }
                    if (col.size() != 0) continue;
                    hmap.remove(pe);
                }
            }
            ++i;
        }
    }

    public Map<String, String> getBindingsForPath(String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        T elem = this.getElementForPath(path);
        if (elem != null) {
            StringTokenizer stok1 = new StringTokenizer(path, "/");
            StringTokenizer stok2 = new StringTokenizer(this.addedpaths.get(elem), "/");
            while (stok1.hasMoreTokens() && stok2.hasMoreTokens()) {
                String cpe = stok1.nextToken();
                String ape = stok2.nextToken();
                if (!ape.startsWith("{") || !ape.endsWith("}")) continue;
                String varname = ape.substring(1, ape.length() - 1);
                ret.put(varname, cpe);
            }
        }
        return ret;
    }

    protected Map<String, Collection<T>> getPathPartMap(int level, boolean add) {
        if (add && level >= this.pathparts.size()) {
            for (int i = this.pathparts.size() - 1; i <= level; ++i) {
                HashMap map = new HashMap();
                this.pathparts.add(map);
            }
        }
        return level < this.pathparts.size() ? this.pathparts.get(level) : null;
    }

    public int getPathDepth(String path) {
        return path == null ? 0 : path.length() - path.replace("/", "").length();
    }

    public int getPathDepth(T elem) {
        String path = this.addedpaths.get(elem);
        return this.getPathDepth(path);
    }

    public String getPathForElement(T elem) {
        return this.addedpaths.get(elem);
    }

    public int size() {
        return this.addedpaths.size();
    }

    public Collection<T> getElements() {
        return this.addedpaths.keySet();
    }

    public static void main(String[] args) {
        PathManager<String> pm = new PathManager<String>();
        pm.addPathElement("a/b/c", "a/b/c");
        pm.addPathElement("a/{varb}/c", "a/{varb}/c");
        pm.addPathElement("a/b/{varc}", "a/b/{varc}");
        pm.addPathElement("a/{varb}/{varc}", "a/{varb}/{varc}");
        pm.addPathElement("a/b/c/d", "a/b/c/d");
        pm.addPathElement("aa/bb/{cc}", "aa/bb/{cc}");
        System.out.println("a/b/c: " + (String)pm.getElementForPath("a/b/c") + " " + pm.getBindingsForPath("a/b/c"));
        System.out.println("a/bbb/c: " + (String)pm.getElementForPath("a/bbb/c") + " " + pm.getBindingsForPath("a/bbb/c"));
        System.out.println("a/dummy/c: " + (String)pm.getElementForPath("a/dummy/c") + " " + pm.getBindingsForPath("a/dummy/c"));
        System.out.println("a/b/c/d: " + (String)pm.getElementForPath("a/b/c/d") + " " + pm.getBindingsForPath("a/b/c/d"));
        System.out.println("d/b/c: " + (String)pm.getElementForPath("d/b/c") + " " + pm.getBindingsForPath("d/b/c"));
        System.out.println("a/lok/doc: " + (String)pm.getElementForPath("a/lok/doc") + " " + pm.getBindingsForPath("a/lok/doc"));
    }
}

