/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish.json;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import jadex.bridge.service.IServiceIdentifier;
import jadex.commons.SReflect;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import jadex.transformation.jsonserializer.processors.AbstractJsonProcessor;
import jadex.transformation.jsonserializer.processors.JsonReadContext;
import jadex.transformation.jsonserializer.processors.JsonWriteContext;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JsonResponseProcessor
extends AbstractJsonProcessor {
    protected boolean isApplicable(Object object, Type type, ClassLoader targetcl, JsonReadContext context) {
        Class clazz = SReflect.getClass((Type)type);
        return object instanceof JsonObject && SReflect.isSupertype(Response.class, (Class)clazz);
    }

    protected boolean isApplicable(Object object, Type type, ClassLoader targetcl, JsonWriteContext context) {
        Class clazz = SReflect.getClass((Type)type);
        return SReflect.isSupertype(Response.class, (Class)clazz);
    }

    protected Object readObject(Object object, Type type, Traverser traverser, List<ITraverseProcessor> conversionprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, ClassLoader targetcl, JsonReadContext context) {
        JsonObject obj = (JsonObject)object;
        Class clazz = SReflect.getClass((Type)type);
        int status = obj.getInt("status", 0);
        String entity = obj.getString("entity", null);
        JsonValue hs = obj.get("headers");
        Map headers = (Map)traverser.traverse((Object)hs, Map.class, conversionprocessors, processors, converter, mode, targetcl, (Object)context);
        Response.ResponseBuilder rb = Response.status((int)status).entity((Object)entity);
        for (Map.Entry entry : headers.entrySet()) {
            if (!(entry.getValue() instanceof Collection)) continue;
            for (Object v : (Collection)entry.getValue()) {
                rb.header((String)entry.getKey(), (Object)((String)v));
            }
        }
        Response ret = rb.build();
        JsonValue idx = obj.get("__id");
        if (idx != null) {
            context.addKnownObject((Object)ret, idx.asInt());
        }
        return ret;
    }

    protected Object writeObject(Object object, Type type, Traverser traverser, List<ITraverseProcessor> conversionprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, ClassLoader targetcl, JsonWriteContext context) {
        JsonWriteContext wr = context;
        wr.addObject(object);
        Response r = (Response)object;
        wr.write("{");
        wr.writeNameValue("status", r.getStatus()).write(", ");
        wr.writeNameString("entity", "" + r.getEntity()).write(", ");
        wr.write("\"headers\":");
        traverser.traverse((Object)r.getHeaders(), Map.class, conversionprocessors, processors, converter, mode, targetcl, (Object)context);
        if (wr.isWriteClass()) {
            wr.write(",").writeClass(IServiceIdentifier.class);
        }
        wr.write("}");
        return object;
    }
}

