/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.IEncodingContext;
import jadex.binary.SerializationConfig;
import jadex.binary.VarInt;
import jadex.commons.SUtil;
import jadex.commons.transformation.STransformation;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractEncodingContext
implements IEncodingContext {
    protected Map<Object, Long> knownobjects;
    protected Object lastinputobject;
    protected List<ITraverseProcessor> preprocessors;
    protected ClassLoader classloader;
    protected Object rootobject;
    protected Object usercontext;
    protected boolean ignorewriteclass;
    protected Set<Class<?>> nonanonclasscache = new HashSet();
    protected Map<String, Integer> stringpool;
    protected Map<Class<?>, Integer> classidcache;
    protected Map<String, Integer> classnamepool;
    protected long writtenbytes;

    public AbstractEncodingContext(Object rootobject, Object usercontext, List<ITraverseProcessor> preprocessors, ClassLoader classloader, SerializationConfig config) {
        this.knownobjects = new IdentityHashMap<Object, Long>();
        this.rootobject = rootobject;
        this.usercontext = usercontext;
        this.preprocessors = preprocessors;
        this.classloader = classloader;
        this.ignorewriteclass = false;
        this.classidcache = new HashMap();
        this.stringpool = config == null ? new HashMap() : config.createEncodingStringPool();
        this.classnamepool = config == null ? new HashMap() : config.createEncodingClassnamePool();
    }

    @Override
    public List<ITraverseProcessor> getPreprocessors() {
        return this.preprocessors;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public Object getRootObject() {
        return this.rootobject;
    }

    @Override
    public long getWrittenBytes() {
        return this.writtenbytes;
    }

    public Object getUserContext() {
        return this.usercontext;
    }

    @Override
    public Set<Class<?>> getNonInnerClassCache() {
        return this.nonanonclasscache;
    }

    @Override
    public long createObjectId() {
        long ret = this.knownobjects.size();
        this.knownobjects.put(this.lastinputobject, ret);
        return ret;
    }

    @Override
    public void setInputObject(Object object) {
        this.lastinputobject = object;
    }

    @Override
    public Long getObjectId(Object object) {
        return this.knownobjects.get(object);
    }

    @Override
    public void setIgnoreNextClassWrite(boolean state) {
        this.ignorewriteclass = state;
    }

    protected boolean isIgnoreNextClassWrite() {
        return this.ignorewriteclass;
    }

    @Override
    public void writeVarInt(long value) {
        try {
            this.write(VarInt.encode(value));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeSignedVarInt(long value) {
        boolean neg = value < 0L;
        value = Math.abs(value);
        long mask = Long.highestOneBit(value) << 2;
        if (neg) {
            mask |= mask >> 1;
        }
        this.writeVarInt(value |= mask);
    }

    @Override
    public void writeString(String string) {
        this.pooledWrite(this.stringpool, string);
    }

    @Override
    public void writeClass(Class<?> clazz) {
        if (!this.isIgnoreNextClassWrite()) {
            Integer classid = this.classidcache.get(clazz);
            if (classid == null) {
                String classname = STransformation.registerClass(clazz);
                classid = this.writeClassname(classname);
                this.classidcache.put(clazz, classid);
            } else {
                this.writeVarInt(classid.intValue());
            }
        } else {
            this.setIgnoreNextClassWrite(false);
        }
    }

    @Override
    public int writeClassname(String name) {
        Integer classid = this.classnamepool.get(name);
        if (classid == null) {
            classid = this.classnamepool.size();
            this.classnamepool.put(name, classid);
            this.writeVarInt(classid.intValue());
            String[] namefragments = name.split("\\.");
            this.writeVarInt(namefragments.length);
            for (String frag : namefragments) {
                this.writeString(frag);
            }
        } else {
            this.writeVarInt(classid.intValue());
        }
        return classid;
    }

    @Override
    public void writeBoolean(boolean bool) {
        this.writeByte((byte)(bool ? 1 : 0));
    }

    @Override
    public void startObjectFrame() {
        this.startObjectFrame(false);
    }

    @Override
    public void startObjectFrame(boolean fixedsize) {
    }

    @Override
    public void stopObjectFrame() {
    }

    protected void pooledWrite(Map<String, Integer> pool, String string) {
        Integer sid = pool.get(string);
        if (sid == null) {
            sid = pool.size();
            pool.put(string, sid);
            this.writeVarInt(sid.intValue());
            if (string != null) {
                byte[] encodedString = string.getBytes(SUtil.UTF8);
                this.writeVarInt(encodedString.length);
                this.write(encodedString);
            } else {
                this.writeVarInt(0x80000000L);
            }
        } else {
            this.writeVarInt(sid.intValue());
        }
    }
}

