/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.binary.SBinarySerializer;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class ArrayCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return clazz != null && clazz.isArray();
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        int length = (int)context.readVarInt();
        Object ret = Array.newInstance(clazz.getComponentType(), length);
        return ret;
    }

    @Override
    public Object decodeSubObjects(Object object, Class<?> clazz, IDecodingContext context) {
        Class<?> compclass = clazz.getComponentType();
        int length = this.getArrayLength(object, compclass);
        if (compclass.isPrimitive()) {
            if (Byte.TYPE.equals(compclass)) {
                byte[] array = (byte[])object;
                context.read(array);
            } else if (Integer.TYPE.equals(compclass)) {
                int[] array = (int[])object;
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (int)context.readSignedVarInt();
                }
            } else if (Boolean.TYPE.equals(compclass)) {
                boolean[] array = (boolean[])object;
                byte[] packed = new byte[(int)Math.ceil((double)array.length / 8.0)];
                context.read(packed);
                for (int i = 0; i < array.length; ++i) {
                    byte mask = (byte)(1 << 7 - i % 8 & 0xFF);
                    array[i] = (packed[i >> 3] & mask & 0xFF) > 0;
                }
            } else if (Float.TYPE.equals(compclass)) {
                float[] array = (float[])object;
                byte[] abuf = new byte[array.length << 2];
                context.read(abuf);
                ByteBuffer buf = ByteBuffer.wrap(abuf);
                buf.order(ByteOrder.BIG_ENDIAN);
                for (int i = 0; i < array.length; ++i) {
                    array[i] = buf.getFloat();
                }
            } else if (Double.TYPE.equals(compclass)) {
                double[] array = (double[])object;
                byte[] abuf = new byte[array.length << 3];
                context.read(abuf);
                ByteBuffer buf = ByteBuffer.wrap(abuf);
                buf.order(ByteOrder.BIG_ENDIAN);
                for (int i = 0; i < array.length; ++i) {
                    array[i] = buf.getDouble();
                }
            } else if (Long.TYPE.equals(compclass)) {
                long[] array = (long[])object;
                byte[] abuf = new byte[array.length << 3];
                context.read(abuf);
                ByteBuffer buf = ByteBuffer.wrap(abuf);
                buf.order(ByteOrder.BIG_ENDIAN);
                for (int i = 0; i < array.length; ++i) {
                    array[i] = buf.getLong();
                }
            } else if (Short.TYPE.equals(compclass)) {
                short[] array = (short[])object;
                byte[] abuf = new byte[array.length << 1];
                context.read(abuf);
                ByteBuffer buf = ByteBuffer.wrap(abuf);
                buf.order(ByteOrder.BIG_ENDIAN);
                for (int i = 0; i < array.length; ++i) {
                    array[i] = buf.getShort();
                }
            } else {
                char[] array = (char[])object;
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (char)context.readVarInt();
                }
            }
        } else {
            Object[] array = (Object[])object;
            for (int i = 0; i < length; ++i) {
                boolean ignoreclass = context.readBoolean();
                Object sub = null;
                sub = ignoreclass ? SBinarySerializer.decodeRawObject(compclass, context) : SBinarySerializer.decodeObject(context);
                array[i] = sub;
            }
        }
        return object;
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        Class<?> compclazz = clazz.getComponentType();
        if (compclazz.isPrimitive()) {
            this.processRawMode(object, compclazz, ec, processors, traverser, ec);
        } else {
            Object[] array = (Object[])object;
            ec.writeVarInt(array.length);
            for (int i = 0; i < array.length; ++i) {
                Object val = array[i];
                if (val == null) {
                    ec.writeBoolean(false);
                    ec.writeClassname("0");
                    continue;
                }
                boolean ignoreclass = val.getClass().equals(compclazz) && ec.getObjectId(val) == null;
                ec.writeBoolean(ignoreclass);
                if (ignoreclass) {
                    ec.setIgnoreNextClassWrite(true);
                }
                traverser.doTraverse(val, val.getClass(), preprocessors, processors, converter, mode, targetcl, (Object)ec);
            }
        }
        return object;
    }

    protected void processRawMode(Object obj, Class compclass, IEncodingContext ec, List<ITraverseProcessor> processors, Traverser traverser, IEncodingContext context) {
        block8: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block7: {
                                        if (!Byte.TYPE.equals(compclass)) break block7;
                                        byte[] array = (byte[])obj;
                                        ec.writeVarInt(array.length);
                                        ec.write(array);
                                        break block8;
                                    }
                                    if (!Integer.TYPE.equals(compclass)) break block9;
                                    int[] array = (int[])obj;
                                    ec.writeVarInt(array.length);
                                    for (int i = 0; i < array.length; ++i) {
                                        ec.writeSignedVarInt(array[i]);
                                    }
                                    break block8;
                                }
                                if (!Boolean.TYPE.equals(compclass)) break block10;
                                boolean[] array = (boolean[])obj;
                                ec.writeVarInt(array.length);
                                byte[] packed = new byte[(int)Math.ceil((double)array.length / 8.0)];
                                for (int i = 0; i < array.length; ++i) {
                                    if (!array[i]) continue;
                                    byte mask = (byte)(1 << 7 - i % 8 & 0xFF);
                                    int n = i >>> 3;
                                    packed[n] = (byte)(packed[n] | mask);
                                }
                                ec.write(packed);
                                break block8;
                            }
                            if (!Float.TYPE.equals(compclass)) break block11;
                            float[] array = (float[])obj;
                            ec.writeVarInt(array.length);
                            byte[] abuf = new byte[array.length << 2];
                            ByteBuffer buf = ByteBuffer.wrap(abuf);
                            buf.order(ByteOrder.BIG_ENDIAN);
                            for (int i = 0; i < array.length; ++i) {
                                buf.putFloat(array[i]);
                            }
                            ec.write(abuf);
                            break block8;
                        }
                        if (!Double.TYPE.equals(compclass)) break block12;
                        double[] array = (double[])obj;
                        ec.writeVarInt(array.length);
                        byte[] abuf = new byte[array.length << 3];
                        ByteBuffer buf = ByteBuffer.wrap(abuf);
                        buf.order(ByteOrder.BIG_ENDIAN);
                        for (int i = 0; i < array.length; ++i) {
                            buf.putDouble(array[i]);
                        }
                        ec.write(abuf);
                        break block8;
                    }
                    if (!Long.TYPE.equals(compclass)) break block13;
                    long[] array = (long[])obj;
                    ec.writeVarInt(array.length);
                    byte[] abuf = new byte[array.length << 3];
                    ByteBuffer buf = ByteBuffer.wrap(abuf);
                    buf.order(ByteOrder.BIG_ENDIAN);
                    for (int i = 0; i < array.length; ++i) {
                        buf.putLong(array[i]);
                    }
                    ec.write(abuf);
                    break block8;
                }
                if (!Short.TYPE.equals(compclass)) break block14;
                short[] array = (short[])obj;
                ec.writeVarInt(array.length);
                byte[] abuf = new byte[array.length << 1];
                ByteBuffer buf = ByteBuffer.wrap(abuf);
                buf.order(ByteOrder.BIG_ENDIAN);
                for (int i = 0; i < array.length; ++i) {
                    buf.putShort(array[i]);
                }
                ec.write(abuf);
                break block8;
            }
            if (!Character.TYPE.equals(compclass)) break block8;
            char[] array = (char[])obj;
            ec.writeVarInt(array.length);
            for (int i = 0; i < array.length; ++i) {
                ec.writeVarInt(array[i]);
            }
        }
    }

    protected int getArrayLength(Object obj, Class compclass) {
        if (!compclass.isPrimitive()) {
            Object[] array = (Object[])obj;
            return array.length;
        }
        if (Byte.TYPE.equals(compclass)) {
            byte[] array = (byte[])obj;
            return array.length;
        }
        if (Integer.TYPE.equals(compclass)) {
            int[] array = (int[])obj;
            return array.length;
        }
        if (Boolean.TYPE.equals(compclass)) {
            boolean[] array = (boolean[])obj;
            return array.length;
        }
        if (Float.TYPE.equals(compclass)) {
            float[] array = (float[])obj;
            return array.length;
        }
        if (Double.TYPE.equals(compclass)) {
            double[] array = (double[])obj;
            return array.length;
        }
        if (Long.TYPE.equals(compclass)) {
            long[] array = (long[])obj;
            return array.length;
        }
        if (Short.TYPE.equals(compclass)) {
            short[] array = (short[])obj;
            return array.length;
        }
        char[] array = (char[])obj;
        return array.length;
    }
}

