/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.binary.SBinarySerializer;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.transformation.BeanIntrospectorFactory;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.annotations.Classname;
import jadex.commons.transformation.traverser.BeanProperty;
import jadex.commons.transformation.traverser.IBeanIntrospector;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.SCloner;
import jadex.commons.transformation.traverser.Traverser;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BeanCodec
extends AbstractCodec {
    protected static final int INTROSPECTOR_CACHE_SIZE = 5000;
    protected IBeanIntrospector intro = BeanIntrospectorFactory.getInstance().getBeanIntrospector(5000);

    @Override
    public boolean isApplicable(Class<?> clazz) {
        return true;
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        Object bean = null;
        boolean isanonclass = context.readBoolean();
        if (isanonclass) {
            String correctcl = context.readString();
            Classname cl = BeanCodec.getAnonClassName(clazz);
            if (cl == null || !correctcl.equals(cl.value())) {
                clazz = BeanCodec.findCorrectInnerClass(0, SReflect.getClassName(clazz), correctcl, context.getClassloader());
            }
        }
        if (clazz != null) {
            try {
                bean = SCloner.createBeanObject((IBeanIntrospector)this.intro, clazz);
            }
            catch (Exception e) {
                context.getErrorReporter().exceptionOccurred((Exception)SUtil.convertToRuntimeException((Throwable)e));
            }
        } else {
            context.getErrorReporter().exceptionOccurred((Exception)new ClassNotFoundException("Class not found: " + context.getCurrentClassName()));
        }
        return bean;
    }

    @Override
    public Object decodeSubObjects(Object object, Class<?> clazz, IDecodingContext context) {
        if (object != null) {
            BeanCodec.readBeanProperties(object, clazz, context, this.intro);
        } else {
            int size = (int)context.readVarInt();
            for (int i = 0; i < size; ++i) {
                context.readString();
                SBinarySerializer.decodeObject(context);
            }
        }
        return object;
    }

    public boolean isApplicable(Object object, Type type, boolean clone, ClassLoader targetcl) {
        return object != null;
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        if (!ec.getNonInnerClassCache().contains(clazz)) {
            if (clazz != null && clazz.isAnonymousClass()) {
                ec.writeBoolean(true);
                Classname cn = BeanCodec.getAnonClassName(clazz);
                if (cn == null) {
                    Object msg = String.valueOf(clazz);
                    msg = (String)msg + " methods: ";
                    for (Method method : clazz.getDeclaredMethods()) {
                        msg = (String)msg + " " + method.getName();
                    }
                    msg = (String)msg + " fields: ";
                    for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                        msg = (String)msg + " " + ((Field)accessibleObject).getName();
                    }
                    throw new RuntimeException("Anonymous Class without Classname identifier not supported: " + (String)msg);
                }
                ec.writeString(cn.value());
            } else {
                ec.writeBoolean(false);
                ec.getNonInnerClassCache().add(clazz);
            }
        } else {
            ec.writeBoolean(false);
        }
        BeanCodec.writeBeanProperties(object, clazz, preprocessors, processors, traverser, converter, mode, ec, this.intro);
        return object;
    }

    public static void writeBeanProperties(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, Traverser traverser, IStringConverter converter, Traverser.MODE mode, IEncodingContext ec, IBeanIntrospector intro) {
        Map props = intro.getBeanProperties(clazz, true, false);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Class> clazzes = new ArrayList<Class>();
        for (Map.Entry entry : props.entrySet()) {
            Object val;
            BeanProperty prop = (BeanProperty)entry.getValue();
            if (prop == null || !prop.isReadable() || (val = prop.getPropertyValue(object)) == null) continue;
            names.add(prop.getName());
            clazzes.add(prop.getType());
            values.add(val);
        }
        ec.writeVarInt(names.size());
        for (int i = 0; i < names.size(); ++i) {
            ec.writeString((String)names.get(i));
            Object val = values.get(i);
            traverser.doTraverse(val, (Type)clazzes.get(i), preprocessors, processors, converter, mode, ec.getClassLoader(), (Object)ec);
        }
    }

    public static void readBeanProperties(Object object, Class clazz, IDecodingContext context, IBeanIntrospector intro) {
        Map props = intro.getBeanProperties(clazz, true, false);
        int size = (int)context.readVarInt();
        for (int i = 0; i < size; ++i) {
            String name = context.readString();
            Object val = null;
            val = SBinarySerializer.decodeObject(context);
            if (val == null) continue;
            try {
                BeanProperty prop = (BeanProperty)props.get(name);
                if (prop == null || !prop.isWritable()) continue;
                prop.setPropertyValue(object, val);
                continue;
            }
            catch (Exception e) {
                context.getErrorReporter().exceptionOccurred(e);
            }
        }
    }

    private static final Class findCorrectInnerClass(int level, String startname, String annotatedname, ClassLoader classloader) {
        int marker = 0;
        Object basename = startname;
        for (int i = -1; i < level; ++i) {
            marker = ((String)basename).lastIndexOf(36);
            if (marker == -1) {
                return null;
            }
            basename = ((String)basename).substring(0, marker);
        }
        basename = (String)basename + "$";
        int exclude = Integer.parseInt(startname.substring(marker + 1, startname.length()));
        Class ret = null;
        int classindex = 0;
        boolean searching = true;
        while (searching) {
            block11: {
                if (classindex != exclude) {
                    String candidatename = (String)basename + classindex;
                    try {
                        Class candclass = SReflect.findClass((String)candidatename, null, (ClassLoader)classloader);
                        if (level == 0) {
                            Classname candclassname = BeanCodec.getAnonClassName(candclass);
                            if (candclassname != null && annotatedname.equals(candclassname.value())) {
                                ret = candclass;
                                searching = false;
                            }
                        } else {
                            ret = BeanCodec.findCorrectInnerClass(level - 1, startname, annotatedname, classloader);
                            if (ret != null) {
                                searching = false;
                            }
                        }
                    }
                    catch (ClassNotFoundException e) {
                        if (classindex == 0) break block11;
                        searching = false;
                    }
                }
            }
            ++classindex;
        }
        if (ret == null) {
            ret = BeanCodec.findCorrectInnerClass(level + 1, startname, annotatedname, classloader);
        }
        return ret;
    }

    private static final Classname getAnonClassName(Class clazz) {
        Field[] fields = clazz.getFields();
        Classname cn = null;
        for (int i = 0; i < fields.length && cn == null; ++i) {
            if (!fields[i].isAnnotationPresent(Classname.class)) continue;
            cn = fields[i].getAnnotation(Classname.class);
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length && cn == null; ++i) {
            if (!methods[i].isAnnotationPresent(Classname.class)) continue;
            cn = methods[i].getAnnotation(Classname.class);
        }
        return cn;
    }
}

