/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.commons.SReflect;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class CalendarCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return SReflect.isSupertype(Calendar.class, clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        Calendar ret = null;
        byte[] abuf = new byte[8];
        context.read(abuf);
        ByteBuffer buf = ByteBuffer.wrap(abuf);
        buf.order(ByteOrder.BIG_ENDIAN);
        try {
            ret = (Calendar)clazz.newInstance();
            ret.setTime(new Date(buf.getLong()));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        long time = ((Calendar)object).getTime().getTime();
        byte[] abuf = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(abuf);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putLong(time);
        ec.write(abuf);
        return object;
    }
}

