/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.binary.SBinarySerializer;
import jadex.commons.SReflect;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.List;

public class CertificateCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return SReflect.isSupertype(Certificate.class, clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        try {
            String type = context.readString();
            byte[] data = (byte[])SBinarySerializer.decodeObject(context);
            CertificateFactory cf = CertificateFactory.getInstance(type);
            return cf.generateCertificate(new ByteArrayInputStream(data));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        try {
            ec.writeString(((Certificate)object).getType());
            byte[] encimg = ((Certificate)object).getEncoded();
            traverser.doTraverse((Object)encimg, encimg.getClass(), preprocessors, processors, converter, mode, targetcl, (Object)ec);
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

