/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractDecodingContext;
import jadex.binary.IDecoderHandler;
import jadex.binary.SerializationConfig;
import jadex.commons.transformation.traverser.IErrorReporter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;

public class DataInputDecodingContext
extends AbstractDecodingContext {
    protected DataInput di;
    protected int offset;

    public DataInputDecodingContext(DataInput di, List<IDecoderHandler> decoderhandlers, List<ITraverseProcessor> postprocessors, Object usercontext, ClassLoader classloader, IErrorReporter errorreporter, SerializationConfig config) {
        this(di, decoderhandlers, postprocessors, usercontext, classloader, errorreporter, config, 0);
    }

    public DataInputDecodingContext(DataInput di, List<IDecoderHandler> decoderhandlers, List<ITraverseProcessor> postprocessors, Object usercontext, ClassLoader classloader, IErrorReporter errorreporter, SerializationConfig config, int offset) {
        super(decoderhandlers, postprocessors, usercontext, classloader, errorreporter, config);
        this.di = di;
    }

    @Override
    public byte readByte() {
        byte ret = 0;
        try {
            ret = this.di.readByte();
            if (ret == -1) {
                throw new RuntimeException("Stream ended unexpectedly during read.");
            }
            ++this.offset;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    @Override
    public byte[] read(int count) {
        byte[] ret = new byte[count];
        this.read(ret);
        return ret;
    }

    @Override
    public byte[] read(byte[] array) {
        return this.read(array, -1, -1);
    }

    @Override
    public byte[] read(byte[] array, int woffset, int wlength) {
        woffset = woffset < 0 ? 0 : woffset;
        int n = wlength = wlength < 0 ? array.length - woffset : wlength;
        if (wlength == 0) {
            return array;
        }
        try {
            this.di.readFully(array, woffset, wlength);
            this.offset += wlength;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return array;
    }

    @Override
    public int getCurrentOffset() {
        return this.offset;
    }
}

