/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.IDecoderHandler;
import jadex.binary.SerializationConfig;
import jadex.binary.StreamDecodingContext;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.transformation.traverser.IErrorReporter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

public class FramingStreamDecodingContext
extends StreamDecodingContext {
    protected Deque<Tuple2<Integer, Integer>> framestack = new ArrayDeque<Tuple2<Integer, Integer>>();

    public FramingStreamDecodingContext(InputStream is, List<IDecoderHandler> decoderhandlers, List<ITraverseProcessor> postprocessors, Object usercontext, ClassLoader classloader, IErrorReporter errorreporter, SerializationConfig config) {
        super(is, decoderhandlers, postprocessors, usercontext, classloader, errorreporter, config, 0);
    }

    public FramingStreamDecodingContext(InputStream is, List<IDecoderHandler> decoderhandlers, List<ITraverseProcessor> postprocessors, Object usercontext, ClassLoader classloader, IErrorReporter errorreporter, SerializationConfig config, int offset) {
        super(is, decoderhandlers, postprocessors, usercontext, classloader, errorreporter, config, offset);
    }

    @Override
    public void startObjectFrame(boolean fixedsize) {
        int framesize = -1;
        if (fixedsize) {
            byte[] encsize = new byte[4];
            this.read(encsize);
            framesize = SUtil.bytesToInt((byte[])encsize);
        } else {
            framesize = (int)this.readVarInt();
        }
        Tuple2 frameinfo = new Tuple2((Object)this.offset, (Object)framesize);
        this.framestack.push((Tuple2<Integer, Integer>)frameinfo);
    }

    @Override
    public void stopObjectFrame() {
        Tuple2<Integer, Integer> frameinfo = this.framestack.pop();
        int remaining = (Integer)frameinfo.getSecondEntity() - (this.offset - (Integer)frameinfo.getFirstEntity());
        if (remaining > 0) {
            try {
                this.is.skip(remaining);
            }
            catch (IOException e) {
                SUtil.throwUnchecked((Throwable)e);
            }
        }
    }
}

