/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.commons.SReflect;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public class InetAddressCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return SReflect.isSupertype(InetAddress.class, clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        InetAddress ret = null;
        try {
            ret = InetAddress.getByName(context.readString());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        ec.writeString(((InetAddress)object).getHostAddress());
        return object;
    }
}

