/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.util.List;

public class LocalDateTimeCodec
extends AbstractCodec {
    public static final Class<?> CHRONOLOCALDATECLASS;
    public static final Class<?> LOCALTIMECLASS;
    public static final Class<?> CHRONOLOCALDATETIMECLASS;

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        ec.writeString(object.toString());
        return object;
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        Object ret = null;
        try {
            ret = clazz.getMethod("parse", CharSequence.class).invoke(null, context.readString());
        }
        catch (Exception e) {
            SUtil.rethrowAsUnchecked((Throwable)e);
        }
        return ret;
    }

    @Override
    public boolean isApplicable(Class<?> clazz) {
        boolean ret = CHRONOLOCALDATECLASS != null && SReflect.isSupertype(CHRONOLOCALDATECLASS, clazz) || LOCALTIMECLASS != null && SReflect.isSupertype(LOCALTIMECLASS, clazz) || CHRONOLOCALDATETIMECLASS != null && SReflect.isSupertype(CHRONOLOCALDATETIMECLASS, clazz);
        return ret;
    }

    @Override
    public boolean canReference(Object object, Class<?> clazz, IEncodingContext ec) {
        return false;
    }

    static {
        Class<?> localdateclass = null;
        Class<?> localtimeclass = null;
        Class<?> localdatetimeclass = null;
        try {
            localdateclass = Class.forName("java.time.chrono.ChronoLocalDate");
            localtimeclass = Class.forName("java.time.LocalTime");
            localdatetimeclass = Class.forName("java.time.chrono.ChronoLocalDateTime");
        }
        catch (Exception exception) {
            // empty catch block
        }
        CHRONOLOCALDATECLASS = localdateclass;
        LOCALTIMECLASS = localtimeclass;
        CHRONOLOCALDATETIMECLASS = localdatetimeclass;
    }
}

