/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.binary.SBinarySerializer;
import jadex.commons.SReflect;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogRecordCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return SReflect.isSupertype(LogRecord.class, clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        Level level = (Level)SBinarySerializer.decodeObject(context);
        String msg = context.readString();
        long millis = context.readSignedVarInt();
        LogRecord ret = new LogRecord(level, msg);
        ret.setMillis(millis);
        return ret;
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        LogRecord rec = (LogRecord)object;
        Level level = rec.getLevel();
        traverser.doTraverse((Object)level, level.getClass(), preprocessors, processors, converter, mode, targetcl, (Object)ec);
        ec.writeString(rec.getMessage());
        ec.writeSignedVarInt(rec.getMillis());
        return object;
    }
}

