/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.commons.SAccess;
import jadex.commons.SReflect;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.logging.Level;

public class LoggingLevelCodec
extends AbstractCodec {
    Level[] DEFAULT_LEVELS = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};

    @Override
    public boolean isApplicable(Class<?> clazz) {
        return SReflect.isSupertype(Level.class, clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        Level ret = null;
        if (context.readBoolean()) {
            ret = this.DEFAULT_LEVELS[context.readByte() & 0xFF];
        } else {
            String name = context.readString();
            int val = (int)context.readSignedVarInt();
            try {
                Constructor<?> c = clazz.getDeclaredConstructor(String.class, Integer.TYPE);
                SAccess.setAccessible(c, (boolean)true);
                ret = (Level)c.newInstance(name, val);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        int id;
        Level level = (Level)object;
        for (id = 0; id < this.DEFAULT_LEVELS.length && !this.DEFAULT_LEVELS[id].equals(level); ++id) {
        }
        if (id < this.DEFAULT_LEVELS.length) {
            ec.writeBoolean(true);
            ec.write(new byte[]{(byte)id});
        } else {
            ec.writeBoolean(false);
            String name = level.getName();
            int value = level.intValue();
            ec.writeSignedVarInt(value);
            ec.writeString(name);
        }
        return object;
    }
}

