/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.binary.SBinarySerializer;
import jadex.commons.SReflect;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return SReflect.isSupertype(Map.class, clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        Map ret = null;
        try {
            ret = Collections.EMPTY_MAP.getClass().equals(clazz) ? Collections.EMPTY_MAP : (Map)clazz.newInstance();
        }
        catch (Exception e) {
            ret = new LinkedHashMap();
        }
        return ret;
    }

    @Override
    public Object decodeSubObjects(Object object, Class<?> clazz, IDecodingContext context) {
        Map ret = (Map)object;
        int size = (int)context.readVarInt();
        for (int i = 0; i < size; ++i) {
            Object key = SBinarySerializer.decodeObject(context);
            Object value = SBinarySerializer.decodeObject(context);
            ret.put(key, value);
        }
        return ret;
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        ec.writeVarInt(((Map)object).size());
        Set entries = ((Map)object).entrySet();
        for (Map.Entry entry : entries) {
            Object ev = entry.getKey();
            if (ev == null) {
                ec.writeClassname("0");
            } else {
                traverser.doTraverse(ev, ev.getClass(), preprocessors, processors, converter, mode, targetcl, (Object)ec);
            }
            ev = entry.getValue();
            if (ev == null) {
                ec.writeClassname("0");
                continue;
            }
            traverser.doTraverse(ev, ev.getClass(), preprocessors, processors, converter, mode, targetcl, (Object)ec);
        }
        return object;
    }
}

