/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NumberCodec
extends AbstractCodec {
    public static final NumberCodec INSTANCE = new NumberCodec();
    protected static final Set<Class<?>> TYPES = new HashSet();

    @Override
    public boolean isApplicable(Class<?> clazz) {
        return TYPES.contains(clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        Comparable<Byte> ret = null;
        if (Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)) {
            ret = context.readByte();
        } else if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            ret = context.readBoolean();
        } else if (Character.class.equals(clazz) || Character.TYPE.equals(clazz)) {
            ret = Character.valueOf((char)context.readVarInt());
        } else if (Short.class.equals(clazz) || Short.TYPE.equals(clazz)) {
            byte[] in = new byte[2];
            context.read(in);
            ByteBuffer buff = ByteBuffer.wrap(in);
            buff.order(ByteOrder.BIG_ENDIAN);
            ret = buff.getShort();
        } else if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            ret = (int)context.readSignedVarInt();
        } else if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            byte[] in = new byte[8];
            context.read(in);
            ByteBuffer buff = ByteBuffer.wrap(in);
            buff.order(ByteOrder.BIG_ENDIAN);
            ret = buff.getLong();
        } else if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            byte[] in = new byte[4];
            context.read(in);
            ByteBuffer buff = ByteBuffer.wrap(in);
            buff.order(ByteOrder.BIG_ENDIAN);
            ret = Float.valueOf(buff.getFloat());
        } else {
            byte[] in = new byte[8];
            context.read(in);
            ByteBuffer buff = ByteBuffer.wrap(in);
            buff.order(ByteOrder.BIG_ENDIAN);
            ret = buff.getDouble();
        }
        return ret;
    }

    @Override
    public void recordKnownDecodedObject(Object object, IDecodingContext context) {
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        if (object instanceof Byte) {
            ec.write(new byte[]{(Byte)object});
        } else if (object instanceof Boolean) {
            ec.writeBoolean((Boolean)object);
        } else if (object instanceof Character) {
            ec.writeVarInt(((Character)object).charValue());
        } else if (object instanceof Short) {
            byte[] abuf = new byte[2];
            ByteBuffer buff = ByteBuffer.wrap(abuf);
            buff.order(ByteOrder.BIG_ENDIAN);
            buff.putShort((Short)object);
            ec.write(abuf);
        } else if (object instanceof Integer) {
            ec.writeSignedVarInt(((Integer)object).intValue());
        } else if (object instanceof Long) {
            byte[] abuf = new byte[8];
            ByteBuffer buff = ByteBuffer.wrap(abuf);
            buff.order(ByteOrder.BIG_ENDIAN);
            buff.putLong((Long)object);
            ec.write(abuf);
        } else if (object instanceof Float) {
            byte[] abuf = new byte[4];
            ByteBuffer buff = ByteBuffer.wrap(abuf);
            buff.order(ByteOrder.BIG_ENDIAN);
            buff.putFloat(((Float)object).floatValue());
            ec.write(abuf);
        } else {
            byte[] abuf = new byte[8];
            ByteBuffer buff = ByteBuffer.wrap(abuf);
            buff.order(ByteOrder.BIG_ENDIAN);
            buff.putDouble((Double)object);
            ec.write(abuf);
        }
        return object;
    }

    @Override
    public boolean canReference(Object object, Class<?> clazz, IEncodingContext ec) {
        return false;
    }

    static {
        TYPES.add(Boolean.class);
        TYPES.add(Boolean.TYPE);
        TYPES.add(Integer.class);
        TYPES.add(Integer.TYPE);
        TYPES.add(Double.class);
        TYPES.add(Double.TYPE);
        TYPES.add(Float.class);
        TYPES.add(Float.TYPE);
        TYPES.add(Long.class);
        TYPES.add(Long.TYPE);
        TYPES.add(Short.class);
        TYPES.add(Short.TYPE);
        TYPES.add(Byte.class);
        TYPES.add(Byte.TYPE);
        TYPES.add(Character.class);
        TYPES.add(Character.TYPE);
    }
}

