/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class RectangleCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return Rectangle.class.equals(clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        byte[] abuf = new byte[16];
        context.read(abuf);
        ByteBuffer buf = ByteBuffer.wrap(abuf);
        buf.order(ByteOrder.BIG_ENDIAN);
        int x = buf.getInt();
        int y = buf.getInt();
        int w = buf.getInt();
        int h = buf.getInt();
        return new Rectangle(x, y, w, h);
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        Rectangle r = (Rectangle)object;
        byte[] abuf = new byte[16];
        ByteBuffer buf = ByteBuffer.wrap(abuf);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putInt(r.x);
        buf.putInt(r.y);
        buf.putInt(r.width);
        buf.putInt(r.height);
        ec.write(abuf);
        return object;
    }
}

