/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.ArrayCodec;
import jadex.binary.BeanCodec;
import jadex.binary.BigIntegerCodec;
import jadex.binary.CalendarCodec;
import jadex.binary.CertificateCodec;
import jadex.binary.ClassCodec;
import jadex.binary.CollectionCodec;
import jadex.binary.ColorCodec;
import jadex.binary.CurrencyCodec;
import jadex.binary.DataInputDecodingContext;
import jadex.binary.DataOutputEncodingContext;
import jadex.binary.DateCodec;
import jadex.binary.EncodingContext;
import jadex.binary.EnumCodec;
import jadex.binary.EnumerationCodec;
import jadex.binary.FramingEncodingContext;
import jadex.binary.FramingStreamDecodingContext;
import jadex.binary.IDecoderHandler;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.binary.ImageCodec;
import jadex.binary.InetAddressCodec;
import jadex.binary.LRUCodec;
import jadex.binary.LocalDateTimeCodec;
import jadex.binary.LogRecordCodec;
import jadex.binary.LoggingLevelCodec;
import jadex.binary.MapCodec;
import jadex.binary.MultiCollectionCodec;
import jadex.binary.NumberCodec;
import jadex.binary.OptionalCodec;
import jadex.binary.RectangleCodec;
import jadex.binary.SerializationConfig;
import jadex.binary.SimpleDateFormatCodec;
import jadex.binary.StackTraceElementCodec;
import jadex.binary.StreamDecodingContext;
import jadex.binary.StringCodec;
import jadex.binary.ThrowableCodec;
import jadex.binary.TimestampCodec;
import jadex.binary.TupleCodec;
import jadex.binary.URICodec;
import jadex.binary.URLCodec;
import jadex.binary.UUIDCodec;
import jadex.commons.SReflect;
import jadex.commons.transformation.traverser.DefaultErrorReporter;
import jadex.commons.transformation.traverser.IErrorReporter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class SBinarySerializer {
    protected static final byte MAGIC_BYTE = -13;
    protected static final int VERSION = 4;
    protected static final String NULL_MARKER = "0";
    protected static final String REFERENCE_MARKER = "1";
    public static final List<ITraverseProcessor> ENCODER_HANDLERS = new ArrayList<ITraverseProcessor>();
    public static final List<IDecoderHandler> DECODER_HANDLERS;

    public static byte[] writeObjectToByteArray(Object val, ClassLoader classloader) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SBinarySerializer.writeObjectToStream(baos, val, classloader);
        return baos.toByteArray();
    }

    public static long writeObjectToStream(OutputStream os, Object val, ClassLoader classloader) {
        return SBinarySerializer.writeObjectToStream(os, val, null, null, classloader);
    }

    public static long writeObjectToStream(OutputStream os, Object val, List<ITraverseProcessor> preprocessors, Object usercontext, ClassLoader classloader) {
        return SBinarySerializer.writeObjectToStream(os, val, preprocessors, null, usercontext, classloader, null);
    }

    public static long writeObjectToStream(OutputStream os, Object val, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> encoderhandlers, Object usercontext, ClassLoader classloader, SerializationConfig config) {
        try {
            os.write(-13);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        encoderhandlers = encoderhandlers == null ? ENCODER_HANDLERS : encoderhandlers;
        EncodingContext context = new EncodingContext(os, val, usercontext, preprocessors, classloader, config);
        context.writeVarInt(4L);
        BinaryWriteTraverser traverser = new BinaryWriteTraverser();
        traverser.traverse(val, null, preprocessors, encoderhandlers, null, Traverser.MODE.PREPROCESS, classloader, context);
        return context.getWrittenBytes();
    }

    public static byte[] writeObjectToFramedArray(Object val, ClassLoader classloader) {
        return SBinarySerializer.writeObjectToFramedArray(val, null, null, null, classloader, null);
    }

    public static byte[] writeObjectToFramedArray(Object val, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> encoderhandlers, Object usercontext, ClassLoader classloader, SerializationConfig config) {
        encoderhandlers = encoderhandlers == null ? ENCODER_HANDLERS : encoderhandlers;
        FramingEncodingContext context = new FramingEncodingContext(val, usercontext, preprocessors, classloader, config);
        context.writeByte((byte)-13);
        context.writeVarInt(4L);
        BinaryWriteTraverser traverser = new BinaryWriteTraverser();
        traverser.traverse(val, null, preprocessors, encoderhandlers, null, Traverser.MODE.PREPROCESS, classloader, context);
        return context.toByteArray();
    }

    public static long writeObjectToDataOutput(DataOutput dato, Object val, ClassLoader classloader) {
        return SBinarySerializer.writeObjectToDataOutput(dato, val, null, null, classloader, null);
    }

    public static long writeObjectToDataOutput(DataOutput dato, Object val, List<ITraverseProcessor> preprocessors, Object usercontext, ClassLoader classloader, SerializationConfig config) {
        return SBinarySerializer.writeObjectToDataOutput(dato, val, preprocessors, null, usercontext, classloader, config);
    }

    public static long writeObjectToDataOutput(DataOutput dato, Object val, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> encoderhandlers, Object usercontext, ClassLoader classloader, SerializationConfig config) {
        try {
            dato.writeByte(-13);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        encoderhandlers = encoderhandlers == null ? ENCODER_HANDLERS : encoderhandlers;
        DataOutputEncodingContext context = new DataOutputEncodingContext(dato, val, usercontext, preprocessors, classloader, config);
        context.writeVarInt(4L);
        BinaryWriteTraverser traverser = new BinaryWriteTraverser();
        traverser.traverse(val, null, preprocessors, encoderhandlers, null, Traverser.MODE.PREPROCESS, classloader, context);
        return context.getWrittenBytes();
    }

    public static Object readObjectFromByteArray(byte[] val, List<ITraverseProcessor> postprocessors, Object usercontext, ClassLoader classloader, IErrorReporter errorreporter) {
        return SBinarySerializer.readObjectFromStream(new ByteArrayInputStream(val), postprocessors, usercontext, classloader, errorreporter, null, null);
    }

    public static Object readObjectFromStream(InputStream is, ClassLoader classloader) {
        return SBinarySerializer.readObjectFromStream(is, null, null, classloader, null, null);
    }

    public static Object readObjectFromStream(InputStream is, List<ITraverseProcessor> postprocessors, Object usercontext, ClassLoader classloader, IErrorReporter errorreporter, SerializationConfig config) {
        return SBinarySerializer.readObjectFromStream(is, postprocessors, usercontext, classloader, errorreporter, config, null);
    }

    public static Object readObjectFromStream(InputStream is, List<ITraverseProcessor> postprocessors, Object usercontext, ClassLoader classloader, IErrorReporter errorreporter, SerializationConfig config, List<IDecoderHandler> decoders) {
        StreamDecodingContext context;
        int streamver;
        try {
            byte mbyte = (byte)is.read();
            if (mbyte != -13) {
                throw new RuntimeException("Decoding failed, magic byte not found., found: " + mbyte);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (errorreporter == null) {
            errorreporter = new DefaultErrorReporter();
        }
        if ((streamver = (int)(context = new StreamDecodingContext(is, decoders == null ? DECODER_HANDLERS : decoders, postprocessors, usercontext, classloader, errorreporter, config)).readVarInt()) > 4) {
            throw new RuntimeException("Version mismatch, stream reported version " + streamver + " should be 4 or lower.");
        }
        context.setVersion(streamver);
        return SBinarySerializer.decodeObject(context);
    }

    public static Object readObjectFromFramedStream(InputStream is, List<ITraverseProcessor> postprocessors, Object usercontext, ClassLoader classloader, IErrorReporter errorreporter, SerializationConfig config) {
        FramingStreamDecodingContext context;
        int streamver;
        try {
            byte mbyte = (byte)is.read();
            if (mbyte != -13) {
                throw new RuntimeException("Decoding failed, magic byte not found., found: " + mbyte);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (errorreporter == null) {
            errorreporter = new DefaultErrorReporter();
        }
        if ((streamver = (int)(context = new FramingStreamDecodingContext(is, DECODER_HANDLERS, postprocessors, usercontext, classloader, errorreporter, config)).readVarInt()) > 4) {
            throw new RuntimeException("Version mismatch, stream reported version " + streamver + " should be 4 or lower.");
        }
        context.setVersion(streamver);
        return SBinarySerializer.decodeObject(context);
    }

    public static Object readObjectFromDataInput(DataInput di, List<ITraverseProcessor> postprocessors, Object usercontext, ClassLoader classloader, IErrorReporter errorreporter, SerializationConfig config) {
        DataInputDecodingContext context;
        int streamver;
        try {
            byte mbyte = di.readByte();
            if (mbyte != -13) {
                throw new RuntimeException("Decoding failed, magic byte not found., found: " + mbyte);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (errorreporter == null) {
            errorreporter = new DefaultErrorReporter();
        }
        if ((streamver = (int)(context = new DataInputDecodingContext(di, DECODER_HANDLERS, postprocessors, usercontext, classloader, errorreporter, config)).readVarInt()) > 4) {
            throw new RuntimeException("Version mismatch, stream reported version " + streamver + " should be 4 or lower.");
        }
        context.setVersion(streamver);
        return SBinarySerializer.decodeObject(context);
    }

    public static Object decodeObject(IDecodingContext context) {
        String classname = context.readClassname();
        Class clazz = null;
        try {
            if (classname.equals(NULL_MARKER)) {
                return null;
            }
            if (classname.equals(REFERENCE_MARKER)) {
                return context.getObjectForId(context.readVarInt());
            }
            clazz = SReflect.findClass((String)classname, null, (ClassLoader)context.getClassloader());
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        return SBinarySerializer.decodeRawObject(clazz, context);
    }

    protected static Object decodeRawObject(Class<?> clazz, IDecodingContext context) {
        int i;
        Object dobject = null;
        List<IDecoderHandler> decoderhandlers = context.getDecoderHandlers();
        IDecoderHandler dechandler = null;
        for (i = 0; i < decoderhandlers.size(); ++i) {
            if (!decoderhandlers.get(i).isApplicable(clazz)) continue;
            dobject = decoderhandlers.get(i).decode(clazz, context);
            dechandler = decoderhandlers.get(i);
            break;
        }
        context.setLastObject(dobject);
        if (context.getPostProcessors() != null) {
            for (i = 0; i < context.getPostProcessors().size(); ++i) {
                ITraverseProcessor pp = context.getPostProcessors().get(i);
                if (!pp.isApplicable(context.getLastObject(), clazz, context.getClassloader(), (Object)context)) continue;
                context.setLastObject(pp.process(context.getLastObject(), clazz, null, context.getPostProcessors(), null, null, Traverser.MODE.POSTPROCESS, context.getClassloader(), (Object)context));
                break;
            }
        }
        if (context.getLastObject() != dobject) {
            context.setObjectForId(context.getObjectId(dobject), context.getLastObject());
        }
        return context.getLastObject();
    }

    static {
        ENCODER_HANDLERS.add(new NumberCodec());
        ENCODER_HANDLERS.add(new StringCodec());
        ENCODER_HANDLERS.add(new ArrayCodec());
        ENCODER_HANDLERS.add(new ClassCodec());
        ENCODER_HANDLERS.add(new CollectionCodec());
        ENCODER_HANDLERS.add(new EnumerationCodec());
        ENCODER_HANDLERS.add(new MultiCollectionCodec());
        ENCODER_HANDLERS.add(new LRUCodec());
        ENCODER_HANDLERS.add(new MapCodec());
        ENCODER_HANDLERS.add(new ColorCodec());
        ENCODER_HANDLERS.add(new ImageCodec());
        ENCODER_HANDLERS.add(new RectangleCodec());
        ENCODER_HANDLERS.add(new URLCodec());
        ENCODER_HANDLERS.add(new URICodec());
        ENCODER_HANDLERS.add(new TupleCodec());
        ENCODER_HANDLERS.add(new DateCodec());
        ENCODER_HANDLERS.add(new CalendarCodec());
        ENCODER_HANDLERS.add(new CurrencyCodec());
        ENCODER_HANDLERS.add(new SimpleDateFormatCodec());
        ENCODER_HANDLERS.add(new InetAddressCodec());
        ENCODER_HANDLERS.add(new LoggingLevelCodec());
        ENCODER_HANDLERS.add(new LogRecordCodec());
        ENCODER_HANDLERS.add(new EnumCodec());
        ENCODER_HANDLERS.add(new UUIDCodec());
        ENCODER_HANDLERS.add(new TimestampCodec());
        ENCODER_HANDLERS.add(new CertificateCodec());
        ENCODER_HANDLERS.add(new StackTraceElementCodec());
        ENCODER_HANDLERS.add(new ThrowableCodec());
        ENCODER_HANDLERS.add(new LocalDateTimeCodec());
        ENCODER_HANDLERS.add(new BigIntegerCodec());
        ENCODER_HANDLERS.add(new OptionalCodec());
        ENCODER_HANDLERS.add(new BeanCodec());
        DECODER_HANDLERS = new ArrayList<IDecoderHandler>();
        for (int i = 0; i < ENCODER_HANDLERS.size(); ++i) {
            DECODER_HANDLERS.add((IDecoderHandler)ENCODER_HANDLERS.get(i));
        }
    }

    protected static class BinaryWriteTraverser
    extends Traverser {
        protected BinaryWriteTraverser() {
        }

        public Object preemptProcessing(Object inputobject, Type inputtype, Object context) {
            IEncodingContext ec = (IEncodingContext)context;
            Long id = ec.getObjectId(inputobject);
            Object ret = null;
            if (id != null) {
                ret = inputobject;
                ec.writeClassname(SBinarySerializer.REFERENCE_MARKER);
                ec.writeVarInt(id);
            } else {
                ec.setInputObject(inputobject);
            }
            return ret;
        }

        public void finalizeProcessing(Object inputobject, Object outputobject, ITraverseProcessor convproc, ITraverseProcessor proc, Object context) {
            IEncodingContext ec = (IEncodingContext)context;
            if (outputobject == null) {
                ec.writeClassname(SBinarySerializer.NULL_MARKER);
            }
        }
    }
}

