/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class SerializationConfig {
    protected List<String> dec3stringpool = new ArrayList<String>();
    protected List<String> dec3classnamepool = new ArrayList<String>();
    protected List<String> dec3fragpool = new ArrayList<String>();
    protected List<String> dec2stringpool = new ArrayList<String>();
    protected List<String> dec2classnamepool = new ArrayList<String>();
    protected List<String> dec2fragpool = new ArrayList<String>();
    protected Map<String, Integer> encstringpool = new HashMap<String, Integer>();
    protected Map<String, Integer> encclassnamepool = new HashMap<String, Integer>();
    protected Map<String, Integer> encfragpool = new HashMap<String, Integer>();

    public SerializationConfig(String[] predefinedstrings) {
        this(predefinedstrings, null);
    }

    @Deprecated
    public SerializationConfig(String[] predefinedstrings, String[] predefinedclassnames) {
        predefinedstrings = predefinedstrings != null ? predefinedstrings : new String[]{};
        predefinedclassnames = predefinedclassnames != null ? predefinedclassnames : new String[]{};
        this.predefineClassnames2(predefinedclassnames);
        this.predefineClassnames3(predefinedclassnames);
        for (int i = 0; i < predefinedstrings.length; ++i) {
            int sid = this.dec3stringpool.size();
            this.dec3stringpool.add(predefinedstrings[i]);
            this.encstringpool.put(predefinedstrings[i], sid);
            this.dec2stringpool.add(predefinedstrings[i]);
        }
    }

    public Map<String, Integer> createEncodingStringPool() {
        return new HashMap<String, Integer>(this.encstringpool);
    }

    public Map<String, Integer> createEncodingFragPool() {
        return new HashMap<String, Integer>(this.encfragpool);
    }

    public Map<String, Integer> createEncodingClassnamePool() {
        return new HashMap<String, Integer>(this.encclassnamepool);
    }

    public List<String> createDecodingStringPool3() {
        return new ArrayList<String>(this.dec3stringpool);
    }

    public List<String> createDecodingClassnamePool3() {
        return new ArrayList<String>(this.dec3classnamepool);
    }

    public List<String> createDecodingFragPool3() {
        return new ArrayList<String>(this.dec3fragpool);
    }

    public List<String> createDecodingStringPool2() {
        return new ArrayList<String>(this.dec2stringpool);
    }

    public List<String> createDecodingClassnamePool2() {
        return new ArrayList<String>(this.dec2classnamepool);
    }

    public List<String> createDecodingFragPool2() {
        return new ArrayList<String>(this.dec2fragpool);
    }

    protected void predefineClassnames3(String[] classnames) {
        HashSet<String> knownfrags = new HashSet<String>();
        for (int i = 0; i < classnames.length; ++i) {
            int classid = this.dec3classnamepool.size();
            this.dec3classnamepool.add(classnames[i]);
            this.encclassnamepool.put(classnames[i], classid);
            int lppos = classnames[i].lastIndexOf(46);
            if (lppos < 0) continue;
            String pkgname = classnames[i].substring(0, lppos);
            String classname = classnames[i].substring(lppos + 1);
            StringTokenizer tok = new StringTokenizer(pkgname, ".");
            while (tok.hasMoreElements()) {
                String frag = tok.nextToken();
                if (knownfrags.contains(frag)) continue;
                int fragid = this.dec3fragpool.size();
                this.dec3fragpool.add(frag);
                this.encfragpool.put(frag, fragid);
                knownfrags.add(frag);
            }
            if (knownfrags.contains(classname)) continue;
            int fragid = this.dec3fragpool.size();
            this.dec3fragpool.add(classname);
            this.encfragpool.put(classname, fragid);
            knownfrags.add(classname);
        }
    }

    protected void predefineClassnames2(String[] classnames) {
        HashSet<String> knownfrags = new HashSet<String>();
        HashSet<String> knownstrings = new HashSet<String>();
        for (int i = 0; i < classnames.length; ++i) {
            this.dec2classnamepool.add(classnames[i]);
            int lppos = classnames[i].lastIndexOf(46);
            if (lppos < 0) continue;
            String pkgname = classnames[i].substring(0, lppos);
            String classname = classnames[i].substring(lppos + 1);
            StringTokenizer tok = new StringTokenizer(pkgname, ".");
            while (tok.hasMoreElements()) {
                String frag = tok.nextToken();
                if (knownfrags.contains(frag)) continue;
                this.dec2fragpool.add(frag);
                if (!knownstrings.contains(frag)) {
                    this.dec2stringpool.add(frag);
                    knownstrings.add(frag);
                }
                knownfrags.add(frag);
            }
            if (knownstrings.contains(classname)) continue;
            this.dec2stringpool.add(classname);
            knownstrings.add(classname);
        }
    }
}

