/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.util.List;

public class TimestampCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return Timestamp.class.equals(clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        byte[] abuf = new byte[8];
        context.read(abuf);
        ByteBuffer buf = ByteBuffer.wrap(abuf);
        buf.order(ByteOrder.BIG_ENDIAN);
        Timestamp ret = new Timestamp(buf.getLong());
        return ret;
    }

    public boolean isApplicable(Object object, Class<?> clazz, boolean clone, ClassLoader targetcl) {
        return this.isApplicable(clazz);
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        long time = ((Timestamp)object).getTime();
        byte[] abuf = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(abuf);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putLong(time);
        ec.write(abuf);
        return object;
    }
}

