/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

public class VarInt {
    private static final byte[] EXTENSION_COUNT_TABLE;
    private static final byte[] REMAINDER_TABLE;
    private static final long[] ADDITIVE_CONSTANTS_TABLE;

    public static final byte getExtensionSize(byte[] varint, int offset) {
        return EXTENSION_COUNT_TABLE[varint[offset] & 0xFF];
    }

    public static final byte getExtensionSize(byte firstbyte) {
        return EXTENSION_COUNT_TABLE[firstbyte & 0xFF];
    }

    public static final long decode(byte[] varint) {
        return VarInt.decode(varint, 0);
    }

    public static final long decode(byte[] varint, int offset) {
        byte ext = VarInt.getExtensionSize(varint, offset);
        return VarInt.decodeWithKnownSize(varint, offset, ext);
    }

    public static final long decodeWithKnownSize(byte[] varint, int offset, byte extsize) {
        long ret = 0L;
        ret |= (long)(REMAINDER_TABLE[varint[offset] & 0xFF] & 0xFF);
        for (int i = 0; i < extsize; ++i) {
            ret <<= 8;
            ret |= (long)(varint[offset + i + 1] & 0xFF);
        }
        return ret += ADDITIVE_CONSTANTS_TABLE[extsize];
    }

    public static final byte[] encode(long val) {
        int size = VarInt.getEncodedSize(val);
        byte[] ret = new byte[size];
        VarInt.encode(val, ret, 0, size);
        return ret;
    }

    public static final int getEncodedSize(long val) {
        int ret = 0;
        while (ADDITIVE_CONSTANTS_TABLE[ret] <= val) {
            ++ret;
        }
        return ret;
    }

    public static final void encode(long val, byte[] buffer, int offset, int size) {
        val -= ADDITIVE_CONSTANTS_TABLE[size - 1];
        for (int i = offset + size - 1; i >= offset; --i) {
            buffer[i] = (byte)(val & 0xFFL);
            val >>>= 8;
        }
        int n = offset;
        buffer[n] = (byte)(buffer[n] | 1 << 8 - size);
    }

    static {
        ADDITIVE_CONSTANTS_TABLE = new long[]{0L, 128L, 16512L, 2113664L, 270549120L, 34630287488L, 4432676798592L, 567382630219904L, 72624976668147840L};
        EXTENSION_COUNT_TABLE = new byte[256];
        REMAINDER_TABLE = new byte[256];
        int num = 9;
        for (int i = 0; i < 256; ++i) {
            if ((i & i - 1) == 0) {
                num = (byte)(num - 1);
            }
            VarInt.EXTENSION_COUNT_TABLE[i] = num;
            VarInt.REMAINDER_TABLE[i] = (byte)(i & ~(1 << 7 - num));
        }
        int n = -2;
    }
}

