/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.IDecoderHandler;
import jadex.binary.IDecodingContext;
import jadex.binary.SerializationConfig;
import jadex.binary.VarInt;
import jadex.commons.SUtil;
import jadex.commons.collection.BiHashMap;
import jadex.commons.transformation.STransformation;
import jadex.commons.transformation.traverser.IErrorReporter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;

public abstract class AbstractDecodingContext
implements IDecodingContext {
    protected ClassLoader classloader;
    protected List<IDecoderHandler> decoderhandlers;
    protected IVersionedHandler versionedhandler = new VersionedHandler4();
    protected List<String> stringpool;
    protected List<String> classnamepool;
    protected Object usercontext;
    protected List<ITraverseProcessor> postprocessors;
    protected Object lastobject;
    protected String currentclassname;
    protected IErrorReporter errorreporter;
    protected BiHashMap<Long, Object> knownobjects;
    protected SerializationConfig config;

    public AbstractDecodingContext(List<IDecoderHandler> decoderhandlers, List<ITraverseProcessor> postprocessors, Object usercontext, ClassLoader classloader, IErrorReporter errorreporter, SerializationConfig config) {
        this.decoderhandlers = decoderhandlers;
        this.postprocessors = postprocessors;
        this.usercontext = usercontext;
        this.classloader = classloader;
        this.errorreporter = errorreporter;
        this.config = config;
        this.knownobjects = new BiHashMap(new HashMap(), new IdentityHashMap());
        if (config == null) {
            this.stringpool = new ArrayList<String>();
            this.classnamepool = new ArrayList<String>();
        } else {
            this.stringpool = config.createDecodingStringPool3();
            this.classnamepool = config.createDecodingClassnamePool3();
        }
    }

    @Override
    public ClassLoader getClassloader() {
        return this.classloader;
    }

    @Override
    public List<IDecoderHandler> getDecoderHandlers() {
        return this.decoderhandlers;
    }

    @Override
    public List<ITraverseProcessor> getPostProcessors() {
        return this.postprocessors;
    }

    @Override
    public long createObjectId(Object object) {
        long id = this.knownobjects.size();
        this.knownobjects.put((Object)id, object);
        return id;
    }

    @Override
    public Object getObjectForId(long id) {
        return this.knownobjects.get((Object)id);
    }

    @Override
    public void setObjectForId(long id, Object object) {
        this.knownobjects.put((Object)id, object);
    }

    @Override
    public Long getObjectId(Object object) {
        return (Long)this.knownobjects.rget(object);
    }

    public Object getUserContext() {
        return this.usercontext;
    }

    @Override
    public IErrorReporter getErrorReporter() {
        return this.errorreporter;
    }

    @Override
    public Object getLastObject() {
        return this.lastobject;
    }

    @Override
    public void setLastObject(Object lastobject) {
        this.lastobject = lastobject;
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() > 0;
    }

    @Override
    public String readString() {
        return this.pooledRead(this.stringpool);
    }

    @Override
    public long readVarInt() {
        byte fb = this.readByte();
        byte ext = VarInt.getExtensionSize(fb);
        byte[] content = new byte[ext + 1];
        content[0] = fb;
        this.read(content, 1, -1);
        return VarInt.decodeWithKnownSize(content, 0, ext);
    }

    @Override
    public long readSignedVarInt() {
        long ret = this.readVarInt();
        long mask = Long.highestOneBit(ret);
        boolean neg = Long.bitCount(ret & (mask |= mask >> 1)) > 1;
        ret &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        if (neg) {
            ret = -ret;
        }
        return ret;
    }

    @Override
    public String readClassname() {
        return this.versionedhandler.readClassname();
    }

    public String pooledRead(List<String> pool) {
        int strid = (int)this.readVarInt();
        String ret = null;
        if (strid >= pool.size()) {
            long rawlen = this.readVarInt();
            if (rawlen <= Integer.MAX_VALUE) {
                int length = (int)rawlen;
                ret = new String(this.read(length), SUtil.UTF8);
                pool.add(ret);
            } else {
                ret = null;
                pool.add(ret);
            }
        } else {
            ret = pool.get(strid);
        }
        return ret;
    }

    @Override
    public String getCurrentClassName() {
        return this.currentclassname;
    }

    protected void setCurrentClassName(String currentclassname) {
        this.currentclassname = currentclassname;
    }

    @Override
    public void setVersion(int version) {
        if (version == 2) {
            if (this.config != null) {
                this.versionedhandler = new VersionedHandler2(this.config.createDecodingFragPool2());
                this.stringpool = this.config.createDecodingStringPool2();
                this.classnamepool = this.config.createDecodingClassnamePool2();
            } else {
                this.versionedhandler = new VersionedHandler2(null);
            }
        } else if (version == 3) {
            if (this.config != null) {
                this.versionedhandler = new VersionedHandler3(this.config.createDecodingFragPool2());
                this.stringpool = this.config.createDecodingStringPool2();
                this.classnamepool = this.config.createDecodingClassnamePool2();
            } else {
                this.versionedhandler = new VersionedHandler3(null);
            }
        } else if (version != 4) {
            throw new IllegalArgumentException("Binary format version is not supported: " + version);
        }
    }

    public void startObjectFrame() {
        this.startObjectFrame(false);
    }

    @Override
    public void startObjectFrame(boolean fixedsize) {
    }

    @Override
    public void stopObjectFrame() {
    }

    public abstract byte[] read(int var1);

    @Override
    public abstract byte[] read(byte[] var1);

    public abstract byte[] read(byte[] var1, int var2, int var3);

    protected class VersionedHandler2
    implements IVersionedHandler {
        protected List<String> pkgpool;

        public VersionedHandler2(List<String> pkgpool) {
            this.pkgpool = pkgpool != null ? pkgpool : new ArrayList();
        }

        @Override
        public String readClassname() {
            String ret = null;
            int classid = (int)AbstractDecodingContext.this.readVarInt();
            if (classid >= AbstractDecodingContext.this.classnamepool.size()) {
                int count = (int)AbstractDecodingContext.this.readVarInt();
                StringBuilder cnb = new StringBuilder();
                for (int i = 0; i < count; ++i) {
                    cnb.append(AbstractDecodingContext.this.pooledRead(this.pkgpool));
                    cnb.append(".");
                }
                cnb.append(AbstractDecodingContext.this.readString());
                ret = cnb.toString();
                AbstractDecodingContext.this.classnamepool.add(ret);
            } else {
                ret = AbstractDecodingContext.this.classnamepool.get(classid);
            }
            ret = STransformation.getClassname((String)ret);
            AbstractDecodingContext.this.setCurrentClassName(ret);
            return ret;
        }
    }

    protected class VersionedHandler3
    implements IVersionedHandler {
        protected List<String> pkgpool = new ArrayList<String>();

        public VersionedHandler3(List<String> pkgpool) {
            this.pkgpool = pkgpool != null ? pkgpool : new ArrayList();
        }

        @Override
        public String readClassname() {
            String ret = null;
            int classid = (int)AbstractDecodingContext.this.readVarInt();
            if (classid >= AbstractDecodingContext.this.classnamepool.size()) {
                int count = (int)AbstractDecodingContext.this.readVarInt();
                StringBuilder cnb = new StringBuilder();
                for (int i = 0; i < count; ++i) {
                    cnb.append(AbstractDecodingContext.this.pooledRead(this.pkgpool));
                    cnb.append(".");
                }
                cnb.append(AbstractDecodingContext.this.pooledRead(this.pkgpool));
                ret = cnb.toString();
                AbstractDecodingContext.this.classnamepool.add(ret);
            } else {
                ret = AbstractDecodingContext.this.classnamepool.get(classid);
            }
            ret = STransformation.getClassname((String)ret);
            AbstractDecodingContext.this.setCurrentClassName(ret);
            return ret;
        }
    }

    protected class VersionedHandler4
    implements IVersionedHandler {
        protected VersionedHandler4() {
        }

        @Override
        public String readClassname() {
            String ret = null;
            int classid = (int)AbstractDecodingContext.this.readVarInt();
            if (classid >= AbstractDecodingContext.this.classnamepool.size()) {
                int count = (int)AbstractDecodingContext.this.readVarInt();
                StringBuilder cnb = new StringBuilder();
                for (int i = 0; i < count - 1; ++i) {
                    cnb.append(AbstractDecodingContext.this.pooledRead(AbstractDecodingContext.this.stringpool));
                    cnb.append(".");
                }
                cnb.append(AbstractDecodingContext.this.pooledRead(AbstractDecodingContext.this.stringpool));
                ret = cnb.toString();
                AbstractDecodingContext.this.classnamepool.add(ret);
            } else {
                ret = AbstractDecodingContext.this.classnamepool.get(classid);
            }
            ret = STransformation.getClassname((String)ret);
            AbstractDecodingContext.this.setCurrentClassName(ret);
            return ret;
        }
    }

    protected static interface IVersionedHandler {
        public String readClassname();
    }
}

