/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class BigIntegerCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return BigInteger.class.equals(clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        int len = (int)context.readVarInt();
        byte[] abuf = new byte[len];
        context.read(abuf);
        ByteBuffer buf = ByteBuffer.wrap(abuf);
        buf.order(ByteOrder.BIG_ENDIAN);
        BigInteger ret = new BigInteger(buf.array());
        return ret;
    }

    public boolean isApplicable(Object object, Class<?> clazz, boolean clone, ClassLoader targetcl) {
        return this.isApplicable(clazz);
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        byte[] ba = ((BigInteger)object).toByteArray();
        ec.writeVarInt(ba.length);
        ec.write(ba);
        return object;
    }
}

