/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.binary.SBinarySerializer;
import jadex.commons.SReflect;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CollectionCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return SReflect.isSupertype(Collection.class, clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        Collection coll = null;
        try {
            coll = Collections.EMPTY_LIST.getClass().equals(clazz) ? Collections.EMPTY_LIST : (Collections.EMPTY_SET.getClass().equals(clazz) ? Collections.EMPTY_SET : (Collection)clazz.newInstance());
        }
        catch (Exception e) {
            coll = SReflect.isSupertype(Set.class, clazz) ? new LinkedHashSet() : new ArrayList();
        }
        return coll;
    }

    @Override
    public Object decodeSubObjects(Object object, Class<?> clazz, IDecodingContext context) {
        Collection coll = (Collection)object;
        int length = (int)context.readVarInt();
        for (int i = 0; i < length; ++i) {
            Object element = SBinarySerializer.decodeObject(context);
            coll.add(element);
        }
        return coll;
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        ec.writeVarInt(((Collection)object).size());
        Collection col = (Collection)object;
        try {
            for (Object val : col) {
                if (val != null) {
                    Class<?> valclazz = val.getClass();
                    traverser.doTraverse(val, valclazz, preprocessors, processors, converter, mode, targetcl, (Object)ec);
                    continue;
                }
                ec.writeClassname("0");
            }
        }
        catch (Exception e) {
            System.out.println("thread trav: " + Thread.currentThread());
            e.printStackTrace();
        }
        return object;
    }
}

