/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.awt.Color;
import java.util.List;

public class ColorCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return Color.class.equals(clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        byte[] ccomps = new byte[4];
        context.read(ccomps);
        Color ret = new Color(ccomps[0] & 0xFF, ccomps[1] & 0xFF, ccomps[2] & 0xFF, ccomps[3] & 0xFF);
        return ret;
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        Color c = (Color)object;
        byte[] ccomps = new byte[]{(byte)c.getRed(), (byte)c.getGreen(), (byte)c.getBlue(), (byte)c.getAlpha()};
        ec.write(ccomps);
        return object;
    }
}

