/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class DateCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return Date.class.equals(clazz) || SimpleDateFormat.class.equals(clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        Cloneable ret = null;
        if (Date.class.equals(clazz)) {
            byte[] abuf = new byte[8];
            context.read(abuf);
            ByteBuffer buf = ByteBuffer.wrap(abuf);
            buf.order(ByteOrder.BIG_ENDIAN);
            ret = new Date(buf.getLong());
        } else if (SimpleDateFormat.class.equals(clazz)) {
            String pattern = context.readString();
            ret = new SimpleDateFormat(pattern);
        }
        return ret;
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        if (Date.class.equals(clazz)) {
            long time = ((Date)object).getTime();
            byte[] abuf = new byte[8];
            ByteBuffer buf = ByteBuffer.wrap(abuf);
            buf.order(ByteOrder.BIG_ENDIAN);
            buf.putLong(time);
            ec.write(abuf);
        } else if (SimpleDateFormat.class.equals(clazz)) {
            String pattern = ((SimpleDateFormat)object).toPattern();
            ec.writeString(pattern);
        }
        return object;
    }
}

