/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.binary.SBinarySerializer;
import jadex.commons.SReflect;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class EnumerationCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return SReflect.isSupertype(Enumeration.class, clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        Vector<Object> vec = new Vector<Object>();
        int length = (int)context.readVarInt();
        for (int count = 0; count < length; ++count) {
            int index = (int)context.readVarInt();
            while (count < index) {
                vec.add(null);
                ++count;
            }
            Object element = SBinarySerializer.decodeObject(context);
            vec.add(element);
        }
        return vec.elements();
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        Enumeration en = (Enumeration)object;
        int count = 0;
        Vector copy = new Vector();
        while (en.hasMoreElements()) {
            Object val = en.nextElement();
            ++count;
            copy.add(val);
        }
        ec.writeVarInt(count);
        count = 0;
        for (Object val : copy) {
            if (val != null) {
                ec.writeVarInt(count);
                Class<?> valclazz = val.getClass();
                traverser.doTraverse(val, valclazz, preprocessors, processors, converter, null, null, (Object)ec);
            }
            ++count;
        }
        Enumeration ret = copy.elements();
        return ret;
    }
}

