/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractEncodingContext;
import jadex.binary.SerializationConfig;
import jadex.binary.VarInt;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;

public class FramingEncodingContext
extends AbstractEncodingContext {
    protected byte[] buffer = new byte[32];
    protected Deque<Tuple2<Integer, Boolean>> framestack = new ArrayDeque<Tuple2<Integer, Boolean>>();

    public FramingEncodingContext(Object rootobject, Object usercontext, List<ITraverseProcessor> preprocessors, ClassLoader classloader, SerializationConfig config) {
        super(rootobject, usercontext, preprocessors, classloader, config);
    }

    @Override
    public void startObjectFrame(boolean fixedsize) {
        if (fixedsize) {
            this.ensureSpace(4);
            this.writtenbytes += 4L;
        } else {
            this.ensureSpace(1);
            ++this.writtenbytes;
        }
        Tuple2 frameinfo = new Tuple2((Object)((int)this.writtenbytes), (Object)fixedsize);
        this.framestack.push((Tuple2<Integer, Boolean>)frameinfo);
    }

    @Override
    public void stopObjectFrame() {
        Tuple2<Integer, Boolean> frameinfo = this.framestack.pop();
        int framesize = (int)(this.writtenbytes - (long)((Integer)frameinfo.getFirstEntity()).intValue());
        if (((Boolean)frameinfo.getSecondEntity()).booleanValue()) {
            SUtil.intIntoBytes((int)framesize, (byte[])this.buffer, (int)((Integer)frameinfo.getFirstEntity() - 4));
        } else {
            int encsize = VarInt.getEncodedSize(framesize);
            if (encsize > 1) {
                this.ensureSpace(encsize - 1);
                System.arraycopy(this.buffer, (Integer)frameinfo.getFirstEntity(), this.buffer, (Integer)frameinfo.getFirstEntity() + encsize - 1, framesize);
                this.writtenbytes += (long)(encsize - 1);
            }
            VarInt.encode(framesize, this.buffer, (Integer)frameinfo.getFirstEntity() - 1, encsize);
        }
    }

    @Override
    public void writeByte(byte b) {
        this.ensureSpace(1);
        this.buffer[(int)this.writtenbytes] = b;
        ++this.writtenbytes;
    }

    @Override
    public void write(byte[] b) {
        this.ensureSpace(b.length);
        System.arraycopy(b, 0, this.buffer, (int)this.writtenbytes, b.length);
        this.writtenbytes += (long)b.length;
    }

    public byte[] toByteArray() {
        if ((long)this.buffer.length > this.writtenbytes) {
            this.buffer = Arrays.copyOf(this.buffer, (int)this.writtenbytes);
        }
        return this.buffer;
    }

    protected void ensureSpace(int requiredsize) {
        if ((long)this.buffer.length - this.writtenbytes < (long)requiredsize) {
            int newsize = this.buffer.length;
            while ((long)(newsize <<= 1) - this.writtenbytes < (long)requiredsize) {
            }
            this.buffer = Arrays.copyOf(this.buffer, newsize);
        }
    }
}

