/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.binary.SBinarySerializer;
import jadex.commons.SReflect;
import jadex.commons.collection.ILRUEntryCleaner;
import jadex.commons.collection.LRU;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LRUCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return SReflect.isSupertype(LRU.class, clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        LRU ret = null;
        try {
            ret = new LRU();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return ret;
    }

    @Override
    public Object decodeSubObjects(Object object, Class<?> clazz, IDecodingContext context) {
        LRU ret = (LRU)object;
        int maxentries = (int)context.readVarInt();
        ret.setMaxEntries(maxentries);
        ILRUEntryCleaner cleaner = (ILRUEntryCleaner)SBinarySerializer.decodeObject(context);
        ret.setCleaner(cleaner);
        int size = (int)context.readVarInt();
        for (int i = 0; i < size; ++i) {
            Object key = SBinarySerializer.decodeObject(context);
            Object value = SBinarySerializer.decodeObject(context);
            ret.put(key, value);
        }
        return ret;
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        ec.writeVarInt(((LRU)object).getMaxEntries());
        ILRUEntryCleaner cleaner = ((LRU)object).getCleaner();
        if (cleaner == null) {
            ec.writeClassname("0");
        } else {
            traverser.doTraverse((Object)cleaner, cleaner.getClass(), preprocessors, processors, converter, mode, targetcl, (Object)ec);
        }
        ec.writeVarInt(((LRU)object).size());
        Set entries = ((LRU)object).entrySet();
        for (Map.Entry entry : entries) {
            Object ev = entry.getKey();
            if (ev == null) {
                ec.writeClassname("0");
            } else {
                traverser.doTraverse(ev, ev.getClass(), preprocessors, processors, converter, mode, targetcl, (Object)ec);
            }
            ev = entry.getValue();
            if (ev == null) {
                ec.writeClassname("0");
                continue;
            }
            traverser.doTraverse(ev, ev.getClass(), preprocessors, processors, converter, mode, targetcl, (Object)ec);
        }
        return object;
    }
}

