/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.binary.SBinarySerializer;
import jadex.commons.SAccess;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.collection.MultiCollection;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public class MultiCollectionCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return SReflect.isSupertype(MultiCollection.class, clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        MultiCollection ret = null;
        try {
            if (MultiCollection.class.equals(clazz)) {
                ret = new MultiCollection();
            } else {
                Constructor<?> c = clazz.getConstructor(Map.class, Class.class);
                ret = (MultiCollection)c.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    @Override
    public Object decodeSubObjects(Object object, Class<?> clazz, IDecodingContext context) {
        Map map = (Map)SBinarySerializer.decodeObject(context);
        String classname = context.readClassname();
        Class type = SReflect.classForName0((String)classname, (ClassLoader)context.getClassloader());
        if (type == null) {
            throw new RuntimeException("MultiCollection type not found: " + String.valueOf(classname));
        }
        try {
            Field field = SReflect.getField(clazz, (String)"map");
            SAccess.setAccessible((AccessibleObject)field, (boolean)true);
            field.set(object, map);
            field = SReflect.getField(clazz, (String)"type");
            SAccess.setAccessible((AccessibleObject)field, (boolean)true);
            field.set(object, type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return object;
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        MultiCollection mc = (MultiCollection)object;
        try {
            Field mapfield = MultiCollection.class.getDeclaredField("map");
            SAccess.setAccessible((AccessibleObject)mapfield, (boolean)true);
            Map map = (Map)mapfield.get(mc);
            traverser.doTraverse((Object)map, map.getClass(), preprocessors, processors, converter, mode, targetcl, (Object)ec);
            Field typefield = MultiCollection.class.getDeclaredField("type");
            SAccess.setAccessible((AccessibleObject)typefield, (boolean)true);
            Class type = (Class)typefield.get(mc);
            ec.writeClass(type);
        }
        catch (Exception e) {
            SUtil.rethrowAsUnchecked((Throwable)e);
        }
        return object;
    }
}

