/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.binary.SBinarySerializer;
import jadex.commons.SReflect;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.lang.reflect.Method;
import java.util.List;

public class OptionalCodec
extends AbstractCodec {
    private static final String OPTIONAL_CLASSNAME = "java.util.Optional";
    private Class<?> optionalClass;
    private Method ofMethod;
    private Method emptyMethod;
    private Method getMethod;
    private Method isPresentMethod;

    private void init() {
        if (this.optionalClass == null) {
            this.optionalClass = SReflect.classForName0((String)OPTIONAL_CLASSNAME, null);
            this.ofMethod = SReflect.getMethod(this.optionalClass, (String)"of", (Class[])new Class[]{Object.class});
            this.emptyMethod = SReflect.getMethod(this.optionalClass, (String)"empty", (Class[])new Class[0]);
            this.getMethod = SReflect.getMethod(this.optionalClass, (String)"get", (Class[])new Class[0]);
            this.isPresentMethod = SReflect.getMethod(this.optionalClass, (String)"isPresent", (Class[])new Class[0]);
        }
    }

    @Override
    public boolean isApplicable(Class<?> clazz) {
        return clazz != null && OPTIONAL_CLASSNAME.equals(clazz.getName());
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        this.init();
        boolean isPresent = context.readBoolean();
        Object o = null;
        try {
            if (isPresent) {
                Object subobject = SBinarySerializer.decodeObject(context);
                o = this.ofMethod.invoke(this.optionalClass, subobject);
            } else {
                o = this.emptyMethod.invoke(this.optionalClass, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return o;
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        this.init();
        try {
            Boolean isPresent = (Boolean)this.isPresentMethod.invoke(object, new Object[0]);
            ec.writeBoolean(isPresent);
            if (isPresent.booleanValue()) {
                Object subObject = this.getMethod.invoke(object, new Object[0]);
                traverser.doTraverse(subObject, null, preprocessors, processors, converter, mode, targetcl, (Object)ec);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return object;
    }
}

