/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.commons.SReflect;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.SStackTraceElementHelper;
import jadex.commons.transformation.traverser.Traverser;
import java.util.List;

public class StackTraceElementCodec
extends AbstractCodec {
    @Override
    public boolean isApplicable(Class<?> clazz) {
        return SReflect.isSupertype(StackTraceElement.class, clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        String classloadername = context.readString();
        String modulename = context.readString();
        String moduleversion = context.readString();
        String classname = context.readString();
        String methodname = context.readString();
        String filename = context.readString();
        int linenumber = (int)context.readSignedVarInt();
        return SStackTraceElementHelper.newInstance((String)classloadername, (String)modulename, (String)moduleversion, (String)classname, (String)methodname, (String)filename, (int)linenumber);
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        StackTraceElement ste = (StackTraceElement)object;
        ec.writeString(SStackTraceElementHelper.getClassLoaderName((StackTraceElement)ste));
        ec.writeString(SStackTraceElementHelper.getModuleName((StackTraceElement)ste));
        ec.writeString(SStackTraceElementHelper.getModuleVersion((StackTraceElement)ste));
        ec.writeString(ste.getClassName());
        ec.writeString(ste.getMethodName());
        ec.writeString(ste.getFileName());
        ec.writeSignedVarInt(ste.getLineNumber());
        return object;
    }
}

