/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractDecodingContext;
import jadex.binary.IDecoderHandler;
import jadex.binary.SerializationConfig;
import jadex.commons.transformation.traverser.IErrorReporter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class StreamDecodingContext
extends AbstractDecodingContext {
    protected InputStream is;
    protected int offset;

    public StreamDecodingContext(InputStream is, List<IDecoderHandler> decoderhandlers, List<ITraverseProcessor> postprocessors, Object usercontext, ClassLoader classloader, IErrorReporter errorreporter, SerializationConfig config) {
        this(is, decoderhandlers, postprocessors, usercontext, classloader, errorreporter, config, 0);
    }

    public StreamDecodingContext(InputStream is, List<IDecoderHandler> decoderhandlers, List<ITraverseProcessor> postprocessors, Object usercontext, ClassLoader classloader, IErrorReporter errorreporter, SerializationConfig config, int offset) {
        super(decoderhandlers, postprocessors, usercontext, classloader, errorreporter, config);
        this.is = is;
        this.offset = 0;
    }

    @Override
    public byte readByte() {
        int ret = 0;
        try {
            ret = this.is.read();
            ++this.offset;
            if (ret == -1) {
                throw new RuntimeException("Stream ended unexpectedly during read.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (byte)ret;
    }

    @Override
    public byte[] read(int count) {
        byte[] ret = new byte[count];
        this.read(ret);
        return ret;
    }

    @Override
    public byte[] read(byte[] array) {
        return this.read(array, -1, -1);
    }

    @Override
    public byte[] read(byte[] array, int woffset, int wlength) {
        woffset = woffset < 0 ? 0 : woffset;
        wlength = wlength < 0 ? array.length - woffset : wlength;
        int read = 0;
        while (read < wlength) {
            try {
                int curread = this.is.read(array, woffset + read, wlength - read);
                read += curread;
                this.offset += curread;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return array;
    }

    @Override
    public int getCurrentOffset() {
        return this.offset;
    }
}

