/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary;

import jadex.binary.AbstractCodec;
import jadex.binary.BeanCodec;
import jadex.binary.IDecodingContext;
import jadex.binary.IEncodingContext;
import jadex.binary.SBinarySerializer;
import jadex.commons.SReflect;
import jadex.commons.transformation.BeanIntrospectorFactory;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.IBeanIntrospector;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import java.lang.reflect.Constructor;
import java.util.List;

public class ThrowableCodec
extends AbstractCodec {
    protected IBeanIntrospector intro = BeanIntrospectorFactory.getInstance().getBeanIntrospector(500);

    @Override
    public boolean isApplicable(Class<?> clazz) {
        return SReflect.isSupertype(Throwable.class, clazz);
    }

    @Override
    public Object createObject(Class<?> clazz, IDecodingContext context) {
        Constructor<?> con2;
        Object ret = null;
        String msg = context.readString();
        Throwable cause = (Throwable)SBinarySerializer.decodeObject(context);
        try {
            con2 = clazz.getConstructor(String.class, Throwable.class);
            ret = con2.newInstance(msg, cause);
        }
        catch (Exception con2) {
            // empty catch block
        }
        if (ret == null) {
            try {
                con2 = clazz.getConstructor(Throwable.class, String.class);
                ret = con2.newInstance(cause, msg);
            }
            catch (Exception con3) {
                // empty catch block
            }
        }
        if (ret == null) {
            try {
                con2 = clazz.getConstructor(Throwable.class);
                ret = con2.newInstance(cause);
            }
            catch (Exception con4) {
                // empty catch block
            }
        }
        if (ret == null) {
            try {
                con2 = clazz.getConstructor(Error.class);
                ret = con2.newInstance(cause);
            }
            catch (Exception con5) {
                // empty catch block
            }
        }
        if (ret == null) {
            try {
                con2 = clazz.getConstructor(String.class);
                ret = con2.newInstance(msg);
                if (ret != null && cause != null) {
                    ((Throwable)ret).initCause(cause);
                }
            }
            catch (Exception con6) {
                // empty catch block
            }
        }
        if (ret == null) {
            try {
                con2 = clazz.getConstructor(new Class[0]);
                ret = con2.newInstance(new Object[0]);
                if (ret != null && cause != null) {
                    ((Throwable)ret).initCause(cause);
                }
            }
            catch (Exception e) {
                RuntimeException rte = new RuntimeException("No empty constructor found for class: " + clazz.getName(), e);
                throw rte;
            }
        }
        if (ret != null) {
            BeanCodec.readBeanProperties(ret, clazz, context, this.intro);
        }
        return ret;
    }

    public boolean isApplicable(Object object, Class<?> clazz, boolean clone, ClassLoader targetcl) {
        return this.isApplicable(clazz);
    }

    @Override
    public Object encode(Object object, Class<?> clazz, List<ITraverseProcessor> preprocessors, List<ITraverseProcessor> processors, IStringConverter converter, Traverser.MODE mode, Traverser traverser, ClassLoader targetcl, IEncodingContext ec) {
        Throwable t = (Throwable)object;
        ec.writeString(t.getMessage());
        Throwable val = t.getCause();
        traverser.doTraverse((Object)val, val != null ? val.getClass() : Throwable.class, preprocessors, processors, converter, mode, targetcl, (Object)ec);
        BeanCodec.writeBeanProperties(object, clazz, preprocessors, processors, traverser, converter, mode, ec, this.intro);
        return object;
    }
}

