/*
 * Decompiled with CFR 0.152.
 */
package jadex.binary.persistent.collections;

import jadex.binary.SBinarySerializer;
import jadex.binary.VarInt;
import jadex.commons.SUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PersistentMap<K, V>
implements Map<K, V> {
    protected Map<K, ValueInfo> indexmap;
    protected File file;
    protected String mode;
    protected RandomAccessFile raf;
    protected long dirtybytes = 0L;
    protected long autocompactionthreshold = Long.MAX_VALUE;
    protected ClassLoader classloader;
    long raflength = 0L;

    public PersistentMap(File file, boolean synchronous, ClassLoader classloader) {
        this.indexmap = new HashMap<K, ValueInfo>();
        ClassLoader classLoader = this.classloader = classloader != null ? classloader : PersistentMap.class.getClassLoader();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.file = file;
        this.mode = "rw";
        if (synchronous) {
            this.mode = "rwd";
        }
        try {
            this.raf = new RandomAccessFile(file, this.mode);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (file.length() > 0L) {
            this.buildIndex();
        }
        if (this.dirtybytes > 0L) {
            this.compact();
        }
    }

    public static void main(String[] args) {
        String tmpdir = System.getProperty("java.io.tmpdir");
        File file = new File(tmpdir + File.separator + "pmaptest.map");
        file.delete();
        PersistentMap<CallSite, CallSite> pm = new PersistentMap<CallSite, CallSite>(file, false, null);
        String key = "This is a test key";
        String value = "This is a test value";
        int writes = 1000000;
        long ts = System.currentTimeMillis();
        for (int i = 0; i < writes; ++i) {
            pm.put((CallSite)((Object)(key + i)), (CallSite)((Object)(value + i)));
        }
        String lastval = (String)pm.get(key + (writes - 1));
        long delta = System.currentTimeMillis() - ts;
        System.out.println(delta);
        System.out.println((double)writes / (double)delta * 1000.0);
        System.out.println("Dirty: " + pm.getDirtyBytes() + ", Map size: " + pm.size());
        for (int i = 0; i < 10000; ++i) {
            if (i % 100 == 0) {
                System.out.print(i);
                String val = (String)pm.get(key + i);
                System.out.print(":" + val + ", ");
            }
            pm.remove(key + i);
        }
        System.out.println();
        System.out.println("Dirty: " + pm.getDirtyBytes() + ", Map size: " + pm.size());
        ts = System.currentTimeMillis();
        System.out.println("File Size: " + file.length());
        pm.compact();
        System.out.println("Compaction took: " + (System.currentTimeMillis() - ts));
        System.out.println("Dirty: " + pm.getDirtyBytes() + ", Map size: " + pm.size());
        System.out.println(lastval);
        System.out.println((String)pm.get(key + (writes - 1)));
        System.out.println(lastval.equals(pm.get(key + (writes - 1))));
        pm.close();
        pm = new PersistentMap(file, false, null);
        System.out.println(lastval);
        System.out.println((String)pm.get(key + (writes - 1)));
        System.out.println(lastval.equals(pm.get(key + (writes - 1))));
    }

    @Override
    public int size() {
        return this.indexmap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.indexmap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexmap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, ValueInfo> entry : this.indexmap.entrySet()) {
            if (!(value != null ? value.equals(this.get(entry.getKey())) : value == this.get(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Object ret = null;
        ValueInfo vinfo = this.indexmap.get(key);
        if (vinfo != null) {
            try {
                this.raf.seek(vinfo.getPosition());
                ret = SBinarySerializer.readObjectFromDataInput(this.raf, null, null, this.classloader, null, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return (V)ret;
    }

    @Override
    public V put(K key, V value) {
        V ret = this.doPut(key, value);
        if (this.dirtybytes > this.autocompactionthreshold) {
            this.compact();
        }
        return ret;
    }

    @Override
    public V remove(Object key) {
        V ret = this.doRemove(key);
        if (this.dirtybytes > this.autocompactionthreshold) {
            this.compact();
        }
        return ret;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K key : m.keySet()) {
            this.put(key, m.get(key));
        }
    }

    @Override
    public void clear() {
        this.indexmap.clear();
        try {
            this.raf.close();
            this.file.delete();
            this.file.createNewFile();
            this.raf = new RandomAccessFile(this.file, this.mode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<K> keySet() {
        return this.indexmap.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> ret = new ArrayList<V>(this.indexmap.size());
        for (Map.Entry<K, ValueInfo> entry : this.indexmap.entrySet()) {
            ret.add(this.get(entry.getKey()));
        }
        return ret;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> ret = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, ValueInfo> entry : this.indexmap.entrySet()) {
            final K key = entry.getKey();
            ret.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return PersistentMap.this.get(key);
                }

                @Override
                public V setValue(V value) {
                    Object ret = this.getValue();
                    PersistentMap.this.put(key, value);
                    return ret;
                }
            });
        }
        return ret;
    }

    public void compact() {
        File oldfile = new File(this.file.getAbsolutePath() + ".old");
        File compactfile = new File(this.file.getAbsolutePath() + ".compact");
        try {
            FileOutputStream fos = new FileOutputStream(compactfile);
            HashMap<K, ValueInfo> newindexmap = new HashMap<K, ValueInfo>();
            long pos = 0L;
            byte[] mainbuf = new byte[262144];
            int mainbufsize = 0;
            for (Map.Entry<K, ValueInfo> entry : this.indexmap.entrySet()) {
                ValueInfo info = entry.getValue();
                this.raf.seek(info.getKvPosition());
                byte[] buf = null;
                if (info.kvsize > mainbuf.length) {
                    fos.write(mainbuf, 0, mainbufsize);
                    mainbufsize = 0;
                    buf = new byte[info.kvsize];
                    this.raf.readFully(buf);
                    fos.write(buf);
                } else {
                    if (info.kvsize > mainbuf.length - mainbufsize) {
                        fos.write(mainbuf, 0, mainbufsize);
                        mainbufsize = 0;
                    }
                    buf = mainbuf;
                    this.raf.readFully(buf, mainbufsize, info.kvsize);
                    mainbufsize += info.kvsize;
                }
                int keylength = (int)(info.getPosition() - info.getKvPosition());
                ValueInfo nvinfo = new ValueInfo(pos + (long)keylength, info.getSize(), pos, info.getKvSize());
                pos += (long)info.kvsize;
                newindexmap.put(entry.getKey(), nvinfo);
            }
            if (mainbufsize > 0) {
                fos.write(mainbuf, 0, mainbufsize);
            }
            fos.close();
            this.raf.close();
            SUtil.moveFile((File)this.file, (File)oldfile);
            SUtil.moveFile((File)compactfile, (File)this.file);
            oldfile.delete();
            this.raf = new RandomAccessFile(this.file, this.mode);
            this.dirtybytes = 0L;
            this.indexmap = newindexmap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getDirtyBytes() {
        return this.dirtybytes;
    }

    public void setAutoCompactionThreshold(long threshold) {
        this.autocompactionthreshold = threshold;
        if (this.dirtybytes > this.autocompactionthreshold) {
            this.compact();
        }
    }

    protected void buildIndex() {
        long pos = 0L;
        long length = 0L;
        try {
            length = this.raf.length();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        while (pos < length) {
            try {
                long kvpos = pos;
                this.raf.seek(pos);
                byte firstbyte = this.raf.readByte();
                byte ext = VarInt.getExtensionSize(firstbyte);
                this.raf.seek(pos);
                byte[] buf = new byte[ext + 1];
                this.raf.readFully(buf);
                int entrysize = (int)VarInt.decodeWithKnownSize(buf, 0, ext);
                pos += (long)buf.length;
                Object okey = SBinarySerializer.readObjectFromDataInput(this.raf, null, null, this.classloader, null, null);
                pos += (long)entrysize;
                if (okey instanceof DeletedKey) {
                    ValueInfo valinfo = this.indexmap.remove(((DeletedKey)okey).getKey());
                    if (valinfo == null) continue;
                    this.dirtybytes += (long)valinfo.getKvSize();
                    this.dirtybytes = Math.max(this.dirtybytes, 0L);
                    continue;
                }
                Object key = okey;
                ValueInfo valinfo = this.indexmap.get(key);
                if (valinfo != null) {
                    this.dirtybytes += (long)valinfo.getKvSize();
                    this.dirtybytes = Math.max(this.dirtybytes, 0L);
                }
                firstbyte = this.raf.readByte();
                ext = VarInt.getExtensionSize(firstbyte);
                this.raf.seek(pos);
                buf = new byte[ext + 1];
                this.raf.readFully(buf);
                entrysize = (int)VarInt.decodeWithKnownSize(buf, 0, ext);
                int kvsize = (int)((pos += (long)buf.length) - kvpos + (long)entrysize);
                ValueInfo valinf = new ValueInfo(pos, entrysize, kvpos, kvsize);
                pos += (long)entrysize;
                this.indexmap.put(key, valinf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected V doPut(K key, V value) {
        V ret = this.get(key);
        ValueInfo oldvalinfo = this.indexmap.get(key);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SBinarySerializer.writeObjectToStream(baos, key, this.classloader);
            byte[] kbuf = baos.toByteArray();
            byte[] klbuf = VarInt.encode(kbuf.length);
            baos = new ByteArrayOutputStream();
            SBinarySerializer.writeObjectToStream(baos, value, this.classloader);
            byte[] vbuf = baos.toByteArray();
            byte[] vlbuf = VarInt.encode(vbuf.length);
            long pos = this.raf.length();
            int length = klbuf.length + kbuf.length + vlbuf.length;
            ValueInfo vinfo = new ValueInfo(pos + (long)length, vbuf.length, pos, length + vbuf.length);
            byte[] buf = new byte[length += vbuf.length];
            int apos = 0;
            System.arraycopy(klbuf, 0, buf, apos, klbuf.length);
            System.arraycopy(kbuf, 0, buf, apos += klbuf.length, kbuf.length);
            System.arraycopy(vlbuf, 0, buf, apos += kbuf.length, vlbuf.length);
            System.arraycopy(vbuf, 0, buf, apos += vlbuf.length, vbuf.length);
            apos += vbuf.length;
            this.raf.setLength(pos + (long)length);
            this.raf.seek(pos);
            this.raf.write(buf);
            this.indexmap.put(key, vinfo);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (oldvalinfo != null) {
            this.dirtybytes += (long)oldvalinfo.getKvSize();
            this.dirtybytes = Math.max(this.dirtybytes, 0L);
        }
        return ret;
    }

    public V doRemove(Object key) {
        V ret = null;
        if (this.indexmap.containsKey(key)) {
            ret = this.get(key);
            ValueInfo oldvalinfo = this.indexmap.remove(key);
            DeletedKey dk = new DeletedKey(key);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                SBinarySerializer.writeObjectToStream(baos, dk, this.classloader);
                byte[] kbuf = baos.toByteArray();
                byte[] klbuf = VarInt.encode(kbuf.length);
                long pos = this.raf.length();
                this.raf.setLength(pos + (long)klbuf.length + (long)kbuf.length);
                this.raf.seek(pos);
                this.raf.write(klbuf);
                this.raf.write(kbuf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (oldvalinfo != null) {
                this.dirtybytes += (long)oldvalinfo.getKvSize();
                this.dirtybytes = Math.max(this.dirtybytes, 0L);
            }
        }
        return ret;
    }

    protected static class DeletedKey {
        protected Object key;

        public DeletedKey() {
        }

        public DeletedKey(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public void setKey(Object key) {
            this.key = key;
        }
    }

    protected class ValueInfo {
        protected long position;
        protected int size;
        protected long kvposition;
        protected int kvsize;

        public ValueInfo(long pos, int size, long kvpos, int kvsize) {
            this.position = pos;
            this.size = size;
            this.kvposition = kvpos;
            this.kvsize = kvsize;
        }

        public long getPosition() {
            return this.position;
        }

        public int getSize() {
            return this.size;
        }

        public long getKvPosition() {
            return this.kvposition;
        }

        public int getKvSize() {
            return this.kvsize;
        }
    }
}

