/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml;

import jadex.commons.SUtil;
import jadex.xml.TypeInfo;
import jadex.xml.reader.IObjectReaderHandler;
import jadex.xml.stax.ILocation;
import jadex.xml.stax.QName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StackElement {
    protected IObjectReaderHandler readerhandler;
    protected QName tag;
    protected Object object;
    protected String content;
    protected List<String> parts;
    protected Map<String, String> rawattrs;
    protected TypeInfo typeinfo;
    protected ILocation location;

    public StackElement(QName tag, Object object) {
        this(null, tag, object, null);
    }

    public StackElement(IObjectReaderHandler readerhandler, QName tag, Object object) {
        this(readerhandler, tag, object, null);
    }

    public StackElement(IObjectReaderHandler readerhandler, QName tag, Object object, Map<String, String> rawattrs) {
        this(readerhandler, tag, object, rawattrs, null, null);
    }

    public StackElement(IObjectReaderHandler readerhandler, QName tag, Object object, Map<String, String> rawattrs, TypeInfo typeinfo, ILocation location) {
        this.readerhandler = readerhandler;
        this.tag = tag;
        this.object = object;
        this.rawattrs = rawattrs;
        this.typeinfo = typeinfo;
        this.location = location;
    }

    public QName getTag() {
        return this.tag;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public String getContent() {
        if (this.parts != null) {
            assert (this.content == null);
            if (this.parts.size() == 1) {
                this.content = this.parts.get(0);
            } else {
                int len = 0;
                for (int i = 0; i < this.parts.size(); ++i) {
                    String tmp = this.parts.get(i);
                    len += tmp.length();
                }
                StringBuilder builder = new StringBuilder(len);
                for (int i = 0; i < this.parts.size(); ++i) {
                    builder.append(this.parts.get(i));
                }
                this.content = builder.toString();
            }
            this.parts = null;
        }
        return this.content;
    }

    public Map<String, String> getRawAttributes() {
        return this.rawattrs;
    }

    public TypeInfo getTypeInfo() {
        return this.typeinfo;
    }

    public ILocation getLocation() {
        return this.location;
    }

    public void addContent(String content) {
        assert (content != null);
        if (this.parts == null) {
            this.parts = new ArrayList<String>();
        }
        this.parts.add(content);
    }

    public String toString() {
        return "StackElement(tag=" + this.tag + ", object=" + this.object + ")";
    }

    public int hashCode() {
        int result = 31 + (this.rawattrs == null ? 0 : this.rawattrs.hashCode());
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        result = 31 * result + (this.typeinfo == null ? 0 : this.typeinfo.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean ret;
        boolean bl = ret = this == obj;
        if (!ret && obj instanceof StackElement) {
            StackElement other = (StackElement)obj;
            ret = SUtil.equals(this.rawattrs, other.rawattrs) && SUtil.equals((Object)this.tag, (Object)other.tag) && SUtil.equals((Object)this.typeinfo, (Object)other.typeinfo) && SUtil.equals((Object)this.location, (Object)other.location);
        }
        return ret;
    }

    public IObjectReaderHandler getReaderHandler() {
        return this.readerhandler;
    }
}

