/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.bean;

import jadex.commons.IFilter;
import jadex.commons.SAccess;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.transformation.BasicTypeConverter;
import jadex.commons.transformation.BeanIntrospectorFactory;
import jadex.commons.transformation.STransformation;
import jadex.commons.transformation.annotations.Classname;
import jadex.commons.transformation.traverser.BeanProperty;
import jadex.commons.transformation.traverser.IBeanIntrospector;
import jadex.xml.AccessInfo;
import jadex.xml.AttributeInfo;
import jadex.xml.IContext;
import jadex.xml.IPreProcessor;
import jadex.xml.Namespace;
import jadex.xml.ObjectInfo;
import jadex.xml.SubobjectInfo;
import jadex.xml.TypeInfo;
import jadex.xml.bean.BeanAccessInfo;
import jadex.xml.stax.QName;
import jadex.xml.writer.AWriteContext;
import jadex.xml.writer.AbstractObjectWriterHandler;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class BeanObjectWriterHandler
extends AbstractObjectWriterHandler {
    protected IBeanIntrospector introspector = BeanIntrospectorFactory.getInstance().getBeanIntrospector();
    protected Set<Class<?>> no_typeinfos = Collections.synchronizedSet(new HashSet());
    protected Map<IFilter<Object>, IPreProcessor> preprocessors;

    public BeanObjectWriterHandler(Set<TypeInfo> typeinfos) {
        this(typeinfos, false);
    }

    public BeanObjectWriterHandler(Set<TypeInfo> typeinfos, boolean gentypetags) {
        this(typeinfos, gentypetags, false);
    }

    public BeanObjectWriterHandler(Set<TypeInfo> typeinfos, boolean gentypetags, boolean prefertags) {
        this(typeinfos, gentypetags, prefertags, true);
    }

    public BeanObjectWriterHandler(Set<TypeInfo> typeinfos, boolean gentypetags, boolean prefertags, boolean flattening) {
        super(gentypetags, prefertags, flattening, typeinfos);
    }

    @Override
    public synchronized TypeInfo getTypeInfo(Object object, QName[] fullpath, IContext context) {
        Object type = this.getObjectType(object, context);
        if (this.no_typeinfos.contains(type)) {
            return null;
        }
        TypeInfo ret = super.getTypeInfo(object, fullpath, context);
        if (ret == null && type instanceof Class) {
            ArrayList tocheck = new ArrayList();
            tocheck.add((Class)type);
            for (int i = 0; i < tocheck.size() && ret == null; ++i) {
                Class clazz = (Class)tocheck.get(i);
                ret = this.getTypeInfoManager().getTypeInfo(clazz, fullpath);
                if (ret != null) continue;
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int j = 0; j < interfaces.length; ++j) {
                    tocheck.add(interfaces[j]);
                }
                if ((clazz = clazz.getSuperclass()) == null) continue;
                tocheck.add(clazz);
            }
            if (ret == null && ((Class)type).isArray()) {
                ret = this.getTypeInfoManager().getTypeInfo(Object[].class, fullpath);
            }
            if (ret != null) {
                ObjectInfo cri = ret.getObjectInfo();
                ObjectInfo cricpy = cri != null ? new ObjectInfo(type, cri.getPostProcessor()) : new ObjectInfo(type);
                TypeInfo ti = new TypeInfo(ret.getXMLInfo(), cricpy, ret.getMappingInfo(), ret.getLinkInfo());
                this.getTypeInfoManager().addTypeInfo(ti);
            } else {
                this.no_typeinfos.add((Class)type);
            }
        }
        return ret;
    }

    @Override
    public Object getObjectType(Object object, IContext context) {
        return object.getClass();
    }

    @Override
    public QName getTagName(Object object, IContext context) {
        Object tag;
        String pck;
        if (object != null) {
            Class<?> clazz = object.getClass();
            String clazzname = STransformation.registerClass(clazz);
            int idx = clazzname.lastIndexOf(".");
            pck = idx != -1 ? "typeinfo:" + clazzname.substring(0, idx) : "typeinfo:";
            tag = idx != -1 ? clazzname.substring(idx + 1) : clazzname;
            tag = ((String)tag).replace("$", "-");
            if (clazz.isArray()) {
                int dim = SUtil.getArrayDimension((Object)object);
                tag = ((String)tag).substring(0, ((String)tag).indexOf("[")) + "__" + dim;
            }
        } else {
            pck = "typeinfo:";
            tag = "null";
        }
        AWriteContext wc = (AWriteContext)context;
        Namespace ns = wc.getNamespace(pck);
        return new QName(ns.getURI(), (String)tag, ns.getPrefix());
    }

    @Override
    public QName getTagWithPrefix(QName tag, IContext context) {
        AWriteContext wc = (AWriteContext)context;
        Namespace ns = wc.getNamespace(tag.getNamespaceURI());
        return new QName(ns.getURI(), tag.getLocalPart(), ns.getPrefix());
    }

    @Override
    protected Object getValue(Object object, Object attr, IContext context, Object info) throws Exception {
        Object conv;
        Object value = null;
        if ("__this".equals(attr)) {
            value = object;
        } else {
            BeanAccessInfo bai;
            Method method = null;
            Field field = null;
            Classname xmlc = null;
            boolean found = false;
            AccessInfo ai = info instanceof AttributeInfo ? ((AttributeInfo)info).getAccessInfo() : (info instanceof SubobjectInfo ? ((SubobjectInfo)info).getAccessInfo() : null);
            BeanAccessInfo beanAccessInfo = bai = ai != null && ai.getExtraInfo() instanceof BeanAccessInfo ? (BeanAccessInfo)ai.getExtraInfo() : null;
            if (bai != null && bai.getFetchHelp() != null) {
                Object tmp = bai.getFetchHelp();
                if (tmp instanceof Method) {
                    method = (Method)tmp;
                } else {
                    field = (Field)tmp;
                }
            } else if (attr instanceof BeanProperty && ((BeanProperty)attr).isReadable()) {
                value = ((BeanProperty)attr).getPropertyValue(object);
                found = true;
            } else if (attr instanceof BeanProperty && !((BeanProperty)attr).isReadable()) {
                found = true;
            } else if (attr instanceof String) {
                method = this.findGetMethod(object, (String)attr, new String[]{"get", "is"});
                if (method == null) {
                    try {
                        field = object.getClass().getField((String)attr);
                    }
                    catch (Exception tmp) {}
                }
            } else if (attr instanceof Classname) {
                xmlc = (Classname)attr;
            } else {
                throw new RuntimeException("Unknown attribute type: " + attr);
            }
            if (!found) {
                if (method != null) {
                    try {
                        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(object.getClass().getModifiers())) {
                            SAccess.setAccessible((AccessibleObject)method, (boolean)true);
                        }
                        value = method.invoke(object, new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (field != null) {
                    try {
                        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(object.getClass().getModifiers())) {
                            SAccess.setAccessible((AccessibleObject)field, (boolean)true);
                        }
                        value = field.get(object);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (xmlc != null) {
                    value = xmlc.value();
                } else {
                    throw new RuntimeException("Could not fetch value: " + object + " " + attr);
                }
            }
        }
        if (info instanceof AttributeInfo) {
            conv = ((AttributeInfo)info).getConverter();
            if (conv != null) {
                value = conv.convertObject(value, (Object)context);
            }
        } else if (info instanceof SubobjectInfo && (conv = ((SubobjectInfo)info).getConverter()) != null) {
            value = conv.convertObjectForWrite(value, context);
        }
        return value;
    }

    @Override
    protected Object getProperty(Object info) {
        Object ret = null;
        if (info instanceof AttributeInfo) {
            info = ((AttributeInfo)info).getAccessInfo();
        } else if (info instanceof SubobjectInfo) {
            info = ((SubobjectInfo)info).getAccessInfo();
        }
        if (info instanceof AccessInfo) {
            ret = ((AccessInfo)info).getObjectIdentifier();
        } else if (info instanceof String) {
            ret = info;
        }
        return ret;
    }

    @Override
    protected String getPropertyName(Object property) {
        String ret;
        if (property instanceof BeanProperty) {
            ret = ((BeanProperty)property).getName();
        } else if (property instanceof String) {
            ret = (String)property;
        } else if (property instanceof QName) {
            ret = ((QName)property).getLocalPart();
        } else if (property instanceof Classname) {
            ret = "XML_CLASSNAME";
        } else {
            throw new RuntimeException("Unknown property type: " + property);
        }
        return ret;
    }

    @Override
    protected boolean isBasicType(Object property, Object value) {
        return value == null ? false : BasicTypeConverter.isBuiltInType(value.getClass());
    }

    @Override
    protected Collection<BeanProperty> getProperties(Object object, IContext context, boolean includemethods, boolean includefields) {
        return object == null ? Collections.EMPTY_LIST : this.introspector.getBeanProperties(object.getClass(), includemethods, includefields).values();
    }

    protected Method findGetMethod(Object object, String name, String[] prefixes) {
        Method method = null;
        for (int i = 0; i < prefixes.length && method == null; ++i) {
            String methodname = prefixes[i] + name.substring(0, 1).toUpperCase() + name.substring(1);
            try {
                Class<?> clazz = object.getClass();
                method = SReflect.getExportedMethod(clazz, (String)methodname, (Class[])new Class[0]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }

    @Override
    protected boolean isTypeCompatible(Object object, ObjectInfo info, IContext context) {
        boolean ret = true;
        if (info != null && object != null && info.getTypeInfo() instanceof Class) {
            Class clazz = (Class)info.getTypeInfo();
            ret = clazz.isAssignableFrom(object.getClass());
        }
        return ret;
    }

    @Override
    protected boolean isDecodableToSameType(Object property, Object value, IContext context) {
        boolean ret = true;
        if (value != null) {
            ret = false;
            if (property instanceof BeanProperty) {
                BeanProperty prop = (BeanProperty)property;
                ret = !(value instanceof String) && value.getClass().equals(SReflect.getWrappedType((Class)prop.getSetterType()));
            } else if (property instanceof Classname) {
                ret = true;
            }
        }
        return ret;
    }

    @Override
    public synchronized IPreProcessor[] getPreProcessors(Object object, Object typeinfo) {
        IPreProcessor tiproc;
        ArrayList<IPreProcessor> ret = new ArrayList<IPreProcessor>();
        IPreProcessor iPreProcessor = tiproc = typeinfo instanceof TypeInfo ? ((TypeInfo)typeinfo).getPreProcessor() : null;
        if (tiproc != null) {
            ret.add(tiproc);
        }
        if (this.preprocessors != null) {
            for (IFilter<Object> fil : this.preprocessors.keySet()) {
                if (!fil.filter(object)) continue;
                ret.add(this.preprocessors.get(fil));
            }
        }
        return ret.toArray(new IPreProcessor[ret.size()]);
    }

    public synchronized void addPreProcessor(IFilter<Object> filter, IPreProcessor processor) {
        if (this.preprocessors == null) {
            this.preprocessors = new LinkedHashMap<IFilter<Object>, IPreProcessor>();
        }
        this.preprocessors.put(filter, processor);
    }

    public synchronized void removePreProcessor(IFilter<Object> filter) {
        if (this.preprocessors != null) {
            this.preprocessors.remove(filter);
        }
    }
}

