/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.reader;

import jadex.commons.collection.MultiCollection;
import jadex.xml.IContext;
import jadex.xml.StackElement;
import jadex.xml.TypeInfoPathManager;
import jadex.xml.reader.IObjectReaderHandler;
import jadex.xml.reader.IPostProcessorCall;
import jadex.xml.reader.IXMLReader;
import jadex.xml.reader.LinkData;
import jadex.xml.stax.ILocation;
import jadex.xml.stax.QName;
import jadex.xml.stax.XMLReporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AReadContext
implements IContext {
    protected TypeInfoPathManager pathmanager;
    protected IObjectReaderHandler defaulthandler;
    protected IXMLReader parser;
    protected XMLReporter reporter;
    protected ClassLoader classloader;
    protected Object rootobject;
    protected List<StackElement> stack;
    protected String comment;
    protected Map<String, Object> readobjects;
    protected int readignore;
    protected Object callcontext;
    protected MultiCollection<Integer, IPostProcessorCall> postprocessors;
    protected Map<Object, Integer> arrayinfos;
    protected MultiCollection<Object, LinkData> children;

    public AReadContext(TypeInfoPathManager pathmanager, IObjectReaderHandler handler, IXMLReader parser, XMLReporter reporter, Object callcontext, ClassLoader classloader) {
        this(pathmanager, handler, parser, reporter, callcontext, classloader, null, new ArrayList<StackElement>(), null, null, new HashMap<String, Object>(), 0, (MultiCollection<Integer, IPostProcessorCall>)new MultiCollection());
    }

    public AReadContext(TypeInfoPathManager pathmanager, IObjectReaderHandler handler, IXMLReader parser, XMLReporter reporter, Object callcontext, ClassLoader classloader, Object root, List<StackElement> stack, StackElement topse, String comment, Map<String, Object> readobjects, int readignore, MultiCollection<Integer, IPostProcessorCall> postprocessors) {
        this.pathmanager = pathmanager;
        this.defaulthandler = handler;
        this.parser = parser;
        this.reporter = reporter;
        this.callcontext = callcontext;
        this.classloader = classloader;
        this.stack = stack;
        this.comment = comment;
        this.readobjects = readobjects;
        this.readignore = readignore;
        this.postprocessors = postprocessors;
    }

    public IXMLReader getParser() {
        return this.parser;
    }

    public TypeInfoPathManager getPathManager() {
        return this.pathmanager;
    }

    public IObjectReaderHandler getDefaultHandler() {
        return this.defaulthandler;
    }

    public XMLReporter getReporter() {
        return this.reporter;
    }

    @Override
    public Object getRootObject() {
        return this.rootobject != null ? this.rootobject : (this.stack != null && !this.stack.isEmpty() ? this.stack.get(0).getObject() : null);
    }

    public StackElement getStackElement(int pos) {
        return this.stack.get(pos);
    }

    public StackElement getTopStackElement() {
        StackElement ret = this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
        return ret;
    }

    public void addStackElement(StackElement elem) {
        this.stack.add(elem);
    }

    public void setStackElement(StackElement elem, int pos) {
        this.stack.set(pos, elem);
    }

    public void removeStackElement() {
        StackElement elem = this.stack.remove(this.stack.size() - 1);
        if (this.stack.size() == 0) {
            this.rootobject = elem.getObject();
        }
    }

    public int getStackSize() {
        return this.stack.size();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Map<String, Object> getReadObjects() {
        return this.readobjects;
    }

    public void setReadObjects(Map<String, Object> readobjects) {
        this.readobjects = readobjects;
    }

    public int getReadIgnore() {
        return this.readignore;
    }

    public void setReadIgnore(int readignore) {
        this.readignore = readignore;
    }

    @Override
    public Object getUserContext() {
        return this.callcontext;
    }

    public void setCallContext(Object callcontext) {
        this.callcontext = callcontext;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public MultiCollection<Integer, IPostProcessorCall> getPostProcessors() {
        return this.postprocessors;
    }

    public void setPostProcessors(MultiCollection<Integer, IPostProcessorCall> postprocessors) {
        this.postprocessors = postprocessors;
    }

    public int getArrayCount(Object parent) {
        int ret = 0;
        if (this.arrayinfos == null) {
            this.arrayinfos = new HashMap<Object, Integer>();
        }
        if (this.arrayinfos.containsKey(parent)) {
            ret = this.arrayinfos.get(parent);
        }
        this.arrayinfos.put(parent, ret + 1);
        return ret;
    }

    public List<LinkData> getChildren(Object key) {
        return (List)(this.children == null ? null : this.children.get(key));
    }

    public void addChild(Object key, LinkData value) {
        if (this.children == null) {
            this.children = new MultiCollection();
        }
        this.children.add(key, (Object)value);
    }

    public List<LinkData> removeChildren(Object key) {
        return this.children == null ? null : (List)this.children.remove(key);
    }

    public QName[] getXMLPath(QName tag) {
        QName[] ret = new QName[this.stack.size() + 1];
        for (int i = 0; i < this.stack.size(); ++i) {
            ret[i] = this.stack.get(i).getTag();
        }
        ret[ret.length - 1] = tag;
        return ret;
    }

    protected QName[] getXMLPath() {
        QName[] ret = new QName[this.stack.size()];
        for (int i = 0; i < this.stack.size(); ++i) {
            ret[i] = this.stack.get(i).getTag();
        }
        return ret;
    }

    public StackElement[] getStack() {
        return this.stack.toArray(new StackElement[this.stack.size()]);
    }

    public ILocation getLocation() {
        return this.parser.getLocation();
    }
}

