/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.stax;

import jadex.xml.reader.IXMLReader;
import jadex.xml.stax.ILocation;
import jadex.xml.stax.QName;
import jadex.xml.stax.StaxLocationWrapper;
import jadex.xml.stax.XmlTag;
import jadex.xml.stax.XmlUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StaxReaderWrapper
implements IXMLReader {
    protected BufferedInputStream bis;
    protected XMLStreamReader reader;
    protected LinkedList<XmlTag> tagstack = new LinkedList();
    protected XmlTag closedtag;
    Map<String, String> attrs;

    public StaxReaderWrapper(InputStream in) {
        this.bis = new BufferedInputStream(in);
        XMLInputFactory fac = XMLInputFactory.newInstance();
        try {
            this.reader = fac.createXMLStreamReader(this.bis);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public StaxReaderWrapper(XMLStreamReader reader) {
        this.reader = reader;
    }

    @Override
    public int getEventType() {
        return this.reader.getEventType();
    }

    @Override
    public boolean hasNext() {
        try {
            return this.reader.hasNext();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int next() {
        try {
            XmlTag tag;
            int next = this.reader.next();
            if (next == 1 && this.reader.getName() != null) {
                javax.xml.namespace.QName qname = this.reader.getName();
                this.tagstack.push(new XmlTag(qname.getNamespaceURI(), qname.getLocalPart()));
            }
            if (next == 2 && this.reader.getName() != null && (tag = this.tagstack.peek()) != null && tag.getNamespace().equals(this.reader.getName().getNamespaceURI()) && tag.getLocalPart().equals(this.reader.getLocalName())) {
                this.closedtag = this.tagstack.pop();
            }
            if (next == 1 && this.reader.getAttributeCount() > 0) {
                this.attrs = new HashMap<String, String>(this.reader.getAttributeCount());
                for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                    this.attrs.put(this.reader.getAttributeLocalName(i), XmlUtil.unescapeString(this.reader.getAttributeValue(i)));
                }
            } else {
                this.attrs = null;
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return this.getEventType();
    }

    @Override
    public XmlTag getXmlTag() {
        return this.tagstack.peek();
    }

    @Override
    public XmlTag getClosedTag() {
        return this.closedtag;
    }

    @Override
    public LinkedList<XmlTag> getXmlTagStack() {
        return this.tagstack;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attrs;
    }

    @Override
    public String getText() {
        return this.reader.getText();
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        try {
            if (this.bis != null) {
                this.bis.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public ILocation getLocation() {
        return StaxLocationWrapper.fromLocation(this.reader.getLocation());
    }

    @Override
    public String getLocalName() {
        return this.reader.getLocalName();
    }

    @Override
    public int getAttributeCount() {
        return this.reader.getAttributeCount();
    }

    @Override
    public String getAttributeLocalName(int i) {
        return this.reader.getAttributeLocalName(i);
    }

    @Override
    public String getAttributeValue(int i) {
        return this.reader.getAttributeValue(i);
    }

    @Override
    public QName getName() {
        javax.xml.namespace.QName name = this.reader.getName();
        return new QName(name.getNamespaceURI(), name.getLocalPart(), name.getPrefix());
    }

    @Override
    public String getAttributePrefix(int i) {
        return this.reader.getAttributePrefix(i);
    }

    @Override
    public String getAttributeNamespace(int i) {
        return this.reader.getAttributeNamespace(i);
    }
}

