/*
 * Decompiled with CFR 0.152.
 */
package jadex.xml.writer;

import jadex.commons.collection.MultiCollection;
import jadex.xml.IContext;
import jadex.xml.IPreProcessor;
import jadex.xml.Namespace;
import jadex.xml.StackElement;
import jadex.xml.writer.IObjectWriterHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public abstract class AWriteContext
implements IContext {
    protected IObjectWriterHandler handler;
    protected Object writer;
    protected ClassLoader classloader;
    protected Object rootobject;
    protected Object usercontext;
    protected Map<Object, Object> writtenobs;
    protected List<StackElement> stack;
    protected MultiCollection<Integer, IPreProcessor> preprocessors;
    protected int id;
    protected Map<String, Namespace> namespacebypackage;
    protected int nscnt;

    public AWriteContext(IObjectWriterHandler handler, Object writer, Object usercontext, Object rootobject, ClassLoader classloader) {
        this(handler, writer, usercontext, rootobject, classloader, new IdentityHashMap<Object, Object>(), new ArrayList<StackElement>(), (MultiCollection<Integer, IPreProcessor>)new MultiCollection());
    }

    public AWriteContext(IObjectWriterHandler handler, Object writer, Object usercontext, Object rootobject, ClassLoader classloader, Map<Object, Object> writtenobs, List<StackElement> stack, MultiCollection<Integer, IPreProcessor> preprocessors) {
        this.handler = handler;
        this.writer = writer;
        this.usercontext = usercontext;
        this.rootobject = rootobject;
        this.classloader = classloader;
        this.writtenobs = writtenobs;
        this.stack = stack;
        this.preprocessors = preprocessors;
    }

    public IObjectWriterHandler getHandler() {
        return this.handler;
    }

    public void setHandler(IObjectWriterHandler handler) {
        this.handler = handler;
    }

    public Object getWriter() {
        return this.writer;
    }

    public void setWriter(Object writer) {
        this.writer = writer;
    }

    @Override
    public Object getRootObject() {
        return this.rootobject;
    }

    public void setRootObject(Object root) {
        this.rootobject = root;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    @Override
    public Object getUserContext() {
        return this.usercontext;
    }

    public void setUserContext(Object usercontext) {
        this.usercontext = usercontext;
    }

    public Map<Object, Object> getWrittenObjects() {
        return this.writtenobs;
    }

    public void setWrittenObjects(Map<Object, Object> writtenobs) {
        this.writtenobs = writtenobs;
    }

    public List<StackElement> getStack() {
        return this.stack;
    }

    public void setStack(List<StackElement> stack) {
        this.stack = stack;
    }

    public MultiCollection<Integer, IPreProcessor> getPreProcessors() {
        return this.preprocessors;
    }

    public void setPreProcessors(MultiCollection<Integer, IPreProcessor> preprocessors) {
        this.preprocessors = preprocessors;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Namespace getNamespace(String uri) {
        Namespace ns;
        if (this.namespacebypackage == null) {
            this.namespacebypackage = new HashMap<String, Namespace>();
        }
        if ((ns = this.namespacebypackage.get(uri)) == null) {
            String prefix = "p" + this.nscnt;
            ns = new Namespace(prefix, uri);
            this.namespacebypackage.put(uri, ns);
            ++this.nscnt;
        }
        return ns;
    }
}

