/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import jadex.base.gui.asynctree.INodeListener;
import jadex.base.gui.asynctree.ISwingNodeHandler;
import jadex.base.gui.asynctree.ISwingTreeNode;
import jadex.base.gui.asynctree.ITreeNode;
import jadex.base.gui.componenttree.ComponentTreePanel;
import jadex.base.gui.componenttree.IActiveComponentTreeNode;
import jadex.base.gui.plugin.AbstractJCCPlugin;
import jadex.base.gui.plugin.IControlCenter;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IMessageAdapter;
import jadex.bridge.IRemoteMessageListener;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.clock.IClockService;
import jadex.bridge.service.types.cms.CMSComponentDescription;
import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.bridge.service.types.message.IMessageListener;
import jadex.bridge.service.types.message.IMessageService;
import jadex.bridge.service.types.message.MessageType;
import jadex.commons.IFilter;
import jadex.commons.Properties;
import jadex.commons.Property;
import jadex.commons.SReflect;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingDefaultResultListener;
import jadex.commons.gui.future.SwingDelegationResultListener;
import jadex.commons.gui.future.SwingExceptionDelegationResultListener;
import jadex.commons.transformation.annotations.Classname;
import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.ComponentFilter;
import jadex.tools.comanalyzer.ComponentList;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.MessageFilter;
import jadex.tools.comanalyzer.MessageList;
import jadex.tools.comanalyzer.PaintMaps;
import jadex.tools.comanalyzer.RefreshTask;
import jadex.tools.comanalyzer.ToolPanel;
import jadex.tools.comanalyzer.ToolTab;
import jadex.tools.comanalyzer.chart.ChartPanel;
import jadex.tools.comanalyzer.diagram.DiagramPanel;
import jadex.tools.comanalyzer.graph.GraphPanel;
import jadex.tools.comanalyzer.table.TablePanel;
import jadex.xml.bean.JavaReader;
import jadex.xml.bean.JavaWriter;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.tree.TreePath;

public class ComanalyzerPlugin
extends AbstractJCCPlugin {
    protected static final String[] TYPES = new String[]{"messageeventsent", "messageeventreceived"};
    protected static final String COMANALYZER_IMAGES = "/jadex/tools/comanalyzer/images/";
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"comanalyzer", SGUI.makeIcon(ComanalyzerPlugin.class, (String)"/jadex/tools/comanalyzer/images/new_comanalyzer.png"), "comanalyzer_sel", SGUI.makeIcon(ComanalyzerPlugin.class, (String)"/jadex/tools/comanalyzer/images/new_comanalyzer_sel.png"), "start_observing", SGUI.makeIcon(ComanalyzerPlugin.class, (String)"/jadex/tools/comanalyzer/images/start_observing.png"), "stop_observing", SGUI.makeIcon(ComanalyzerPlugin.class, (String)"/jadex/tools/comanalyzer/images/stop_observing.png"), "introspect_agent", SGUI.makeIcon(ComanalyzerPlugin.class, (String)"/jadex/tools/comanalyzer/images/new_comanalyzer.png"), "close_comanalyzer", SGUI.makeIcon(ComanalyzerPlugin.class, (String)"/jadex/tools/comanalyzer/images/close_comanalyzer.png"), "agent_introspected", SGUI.makeIcon(ComanalyzerPlugin.class, (String)"/jadex/tools/comanalyzer/images/overlay_introspected.png"), "agent_dead", SGUI.makeIcon(ComanalyzerPlugin.class, (String)"/jadex/tools/comanalyzer/images/overlay_dead.png"), "agent_dummy", SGUI.makeIcon(ComanalyzerPlugin.class, (String)"/jadex/tools/comanalyzer/images/agent_dummy.png"), "load", SGUI.makeIcon(ComanalyzerPlugin.class, (String)"/jadex/tools/comanalyzer/images/load.png"), "save", SGUI.makeIcon(ComanalyzerPlugin.class, (String)"/jadex/tools/comanalyzer/images/save2.png"), "clear", SGUI.makeIcon(ComanalyzerPlugin.class, (String)"/jadex/tools/comanalyzer/images/litter.png")});
    protected static final long REFRESHI = Long.MIN_VALUE;
    protected static final long REFRESH1 = 1000L;
    protected static final long REFRESH5 = 5000L;
    protected static final long REFRESH10 = 10000L;
    protected static final long REFRESHA = Long.MAX_VALUE;
    protected long sleep = Long.MIN_VALUE;
    protected Timer timer;
    protected RefreshTask refresh_task;
    protected JSplitPane split;
    protected ComponentTreePanel comptree;
    protected JCheckBoxMenuItem[] checkboxes;
    protected ToolPanel tpanel;
    protected ToolTab table;
    protected ToolTab diagram;
    protected ToolTab graph;
    protected ToolTab chart;
    protected Map listeners;
    protected ComponentList componentlist;
    protected MessageList messagelist;
    protected MessageFilter[] messagefilter;
    protected ComponentFilter[] agentfilter;
    protected static final ComponentFilter[] zeromessages = new ComponentFilter[]{new ComponentFilter("message_visible", 0)};
    protected boolean observe_all_new;
    private int messagenr = 1;
    protected PaintMaps paintmaps;
    protected Set observed;
    protected Map msgservices;
    protected IMessageListener listener;
    protected IClockService clockservice;
    final AbstractAction IGNORE_ALL = new AbstractAction("Ignore All"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Component> update = new ArrayList<Component>();
            Component[] agents = ComanalyzerPlugin.this.componentlist.getAgents();
            for (int i = 0; i < agents.length; ++i) {
                if (!agents[i].getState().equals("observed")) continue;
                agents[i].setState("ignored");
                update.add(agents[i]);
                ComanalyzerPlugin.this.observed.remove(agents[i].getDescription().getName());
                ComanalyzerPlugin.this.comptree.getModel().fireNodeChanged((ITreeNode)ComanalyzerPlugin.this.comptree.getModel().getNode((Object)agents[i].getDescription().getName()));
            }
            ComanalyzerPlugin.this.removeMessageListener(update);
            ComanalyzerPlugin.this.applyAgentFilter();
        }
    };
    final AbstractAction OBSERVE_ALL = new AbstractAction("Observe All"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Component> update = new ArrayList<Component>();
            Component[] agents = ComanalyzerPlugin.this.componentlist.getAgents();
            for (int i = 0; i < agents.length; ++i) {
                if (!agents[i].getState().equals("ignored")) continue;
                agents[i].setState("observed");
                update.add(agents[i]);
                ComanalyzerPlugin.this.observed.add(agents[i].getDescription().getName());
                ComanalyzerPlugin.this.comptree.getModel().fireNodeChanged((ITreeNode)ComanalyzerPlugin.this.comptree.getModel().getNode((Object)agents[i].getDescription().getName()));
            }
            ComanalyzerPlugin.this.addMessageListener(update);
            ComanalyzerPlugin.this.applyAgentFilter();
        }
    };
    final AbstractAction OBSERVE_ALL_NEW = new AbstractAction("Observe All New"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComanalyzerPlugin.this.observe_all_new = ((JCheckBoxMenuItem)e.getSource()).isSelected();
        }
    };
    final AbstractAction REMOVE_DEAD = new AbstractAction("Remove Dead"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Component[] agents = ComanalyzerPlugin.this.componentlist.getAgents();
            for (int i = 0; i < agents.length; ++i) {
                if (!agents[i].getState().equals("dead")) continue;
                ComanalyzerPlugin.this.messagelist.removeMessages(agents[i].getMessages().toArray(new Message[0]));
                ComanalyzerPlugin.this.messagelist.fireMessagesRemoved(agents[i].getMessages().toArray(new Message[0]));
                ComanalyzerPlugin.this.componentlist.removeAgent(agents[i]);
            }
        }
    };
    final AbstractAction REMOVE_ALL_MESSAGES = new AbstractAction("Remove All"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComanalyzerPlugin.this.messagelist.removeAllMessages();
            ArrayList<Component> update = new ArrayList<Component>();
            Component[] agents = ComanalyzerPlugin.this.componentlist.getAgents();
            for (int i = 0; i < agents.length; ++i) {
                agents[i].removeAllMessages();
                update.add(agents[i]);
            }
            ComanalyzerPlugin.this.applyAgentFilter();
        }
    };
    final AbstractAction REMOVE_ALL = new AbstractAction("Remove All Messages And Dead Agents", icons.getIcon("clear")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComanalyzerPlugin.this.messagenr = 0;
            ComanalyzerPlugin.this.messagelist.removeAllMessages();
            Component[] agents = ComanalyzerPlugin.this.componentlist.getAgents();
            for (int i = 0; i < agents.length; ++i) {
                agents[i].removeAllMessages();
                if (!agents[i].getState().equals("dead")) continue;
                ComanalyzerPlugin.this.componentlist.removeAgent(agents[i]);
            }
        }
    };
    final AbstractAction ENABLE_TABLE = new AbstractAction("Enable Table"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComanalyzerPlugin.this.table.setActive(((JCheckBoxMenuItem)e.getSource()).isSelected());
        }
    };
    final AbstractAction ENABLE_DIAGRAM = new AbstractAction("Enable Diagram"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComanalyzerPlugin.this.diagram.setActive(((JCheckBoxMenuItem)e.getSource()).isSelected());
        }
    };
    final AbstractAction ENABLE_GRAPH = new AbstractAction("Enable Graph"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComanalyzerPlugin.this.graph.setActive(((JCheckBoxMenuItem)e.getSource()).isSelected());
        }
    };
    final AbstractAction ENABLE_CHART = new AbstractAction("Enable Chart"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComanalyzerPlugin.this.chart.setActive(((JCheckBoxMenuItem)e.getSource()).isSelected());
        }
    };
    final AbstractAction START_OBSERVING = new AbstractAction("Observe Component", icons.getIcon("introspect_agent")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Component> update = new ArrayList<Component>();
            TreePath[] paths = ComanalyzerPlugin.this.comptree.getTree().getSelectionPaths();
            for (int i = 0; paths != null && i < paths.length; ++i) {
                if (!(paths[i].getLastPathComponent() instanceof IActiveComponentTreeNode)) continue;
                IActiveComponentTreeNode node = (IActiveComponentTreeNode)paths[i].getLastPathComponent();
                IComponentDescription desc = node.getDescription();
                ComanalyzerPlugin.this.observed.add(desc.getName());
                Component agent = ComanalyzerPlugin.this.componentlist.getAgent(desc.getName());
                agent.setState("observed");
                update.add(agent);
                ComanalyzerPlugin.this.applyAgentFilter(agent);
                ComanalyzerPlugin.this.comptree.getModel().fireNodeChanged((ITreeNode)ComanalyzerPlugin.this.comptree.getModel().getNode((Object)desc.getName()));
            }
            ComanalyzerPlugin.this.addMessageListener(update);
        }
    };
    final AbstractAction STOP_OBSERVING = new AbstractAction("Ignore Component", icons.getIcon("close_comanalyzer")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Component> update = new ArrayList<Component>();
            TreePath[] paths = ComanalyzerPlugin.this.comptree.getTree().getSelectionPaths();
            for (int i = 0; paths != null && i < paths.length; ++i) {
                if (!(paths[i].getLastPathComponent() instanceof IActiveComponentTreeNode)) continue;
                IActiveComponentTreeNode node = (IActiveComponentTreeNode)paths[i].getLastPathComponent();
                IComponentDescription desc = node.getDescription();
                ComanalyzerPlugin.this.observed.remove(desc.getName());
                Component agent = ComanalyzerPlugin.this.componentlist.getAgent(desc.getName());
                agent.setState("ignored");
                update.add(agent);
                ComanalyzerPlugin.this.applyAgentFilter(agent);
                ComanalyzerPlugin.this.comptree.getModel().fireNodeChanged((ITreeNode)ComanalyzerPlugin.this.comptree.getModel().getNode((Object)desc.getName()));
            }
            ComanalyzerPlugin.this.removeMessageListener(update);
        }
    };
    final AbstractAction SAVE_MESSAGES = new AbstractAction("Save Messages To file", icons.getIcon("save")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileDialog = new JFileChooser();
            int returnVal = fileDialog.showSaveDialog(null);
            if (returnVal == 0) {
                final String fileName = fileDialog.getSelectedFile().getAbsolutePath();
                ComanalyzerPlugin.this.getJCC().getClassLoader(null).addResultListener((IResultListener)new SwingDefaultResultListener<ClassLoader>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void customResultAvailable(ClassLoader cl) {
                        String xml = JavaWriter.objectToXML((Object)new Object[]{ComanalyzerPlugin.this.componentlist.getAgents(), ComanalyzerPlugin.this.messagelist.getMessages()}, (ClassLoader)cl);
                        byte[] buffer = xml.getBytes();
                        File f = new File(fileName);
                        FileOutputStream out = null;
                        try {
                            out = new FileOutputStream(f);
                            out.write(buffer);
                        }
                        catch (FileNotFoundException e1) {
                            e1.printStackTrace();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        finally {
                            try {
                                if (out != null) {
                                    out.close();
                                }
                            }
                            catch (IOException e1) {}
                        }
                    }
                });
            }
        }
    };
    final AbstractAction LOAD_MESSAGES = new AbstractAction("Load Messages From File", icons.getIcon("load")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            String xml = null;
            JFileChooser fileDialog = new JFileChooser();
            int returnVal = fileDialog.showOpenDialog(null);
            if (returnVal != 0) {
                return;
            }
            String fileName = fileDialog.getSelectedFile().getAbsolutePath();
            File f = new File(fileName);
            FileInputStream in = null;
            try {
                in = new FileInputStream(f);
                byte[] buffer = new byte[(int)f.length()];
                int len = in.read(buffer);
                xml = new String(buffer, 0, len);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (xml != null) {
                final String sxml = xml;
                ComanalyzerPlugin.this.getJCC().getClassLoader(null).addResultListener((IResultListener)new SwingDefaultResultListener<ClassLoader>(){

                    public void customResultAvailable(ClassLoader cl) {
                        Object[] stored = (Object[])JavaReader.objectFromXML((String)sxml, (ClassLoader)cl);
                        ComanalyzerPlugin.this.componentlist.removeAllAgents();
                        Component[] agents = (Component[])stored[0];
                        for (int i = 0; i < agents.length; ++i) {
                            ComanalyzerPlugin.this.componentlist.addAgent(agents[i]);
                        }
                        ComanalyzerPlugin.this.messagelist.removeAllMessages();
                        Message[] messages = (Message[])stored[1];
                        for (int i = 0; i < messages.length; ++i) {
                            ComanalyzerPlugin.this.messagelist.addMessage(messages[i]);
                        }
                        ComanalyzerPlugin.this.messagelist.fireMessagesAdded(messages);
                    }
                });
            }
        }
    };
    final AbstractAction REFRESH_ATONCE = new AbstractAction("Immediately"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComanalyzerPlugin.this.sleep = Long.MIN_VALUE;
            if (ComanalyzerPlugin.this.refresh_task != null) {
                ComanalyzerPlugin.this.refresh_task.cancel();
            }
            ComanalyzerPlugin.this.getJCC().setStatusText("Refresh Rate: Immediately");
        }
    };
    final AbstractAction REFRESH_1S = new AbstractAction("Every 1 s"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComanalyzerPlugin.this.sleep = 1000L;
            if (ComanalyzerPlugin.this.refresh_task != null) {
                ComanalyzerPlugin.this.refresh_task.cancel();
            }
            ComanalyzerPlugin.this.refresh_task = new RefreshTask(ComanalyzerPlugin.this, 1000L);
            ComanalyzerPlugin.this.timer.schedule((TimerTask)ComanalyzerPlugin.this.refresh_task, 1000L, 1000L);
            ComanalyzerPlugin.this.getJCC().setStatusText("Refresh Rate: 1 s");
        }
    };
    final AbstractAction REFRESH_5S = new AbstractAction("Every 5 s"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComanalyzerPlugin.this.sleep = 5000L;
            if (ComanalyzerPlugin.this.refresh_task != null) {
                ComanalyzerPlugin.this.refresh_task.cancel();
            }
            ComanalyzerPlugin.this.refresh_task = new RefreshTask(ComanalyzerPlugin.this, 5000L);
            ComanalyzerPlugin.this.timer.schedule((TimerTask)ComanalyzerPlugin.this.refresh_task, 5000L, 5000L);
            ComanalyzerPlugin.this.getJCC().setStatusText("Refresh Rate: 5 s");
        }
    };
    final AbstractAction REFRESH_AUTO = new AbstractAction("Auto Sensor"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComanalyzerPlugin.this.sleep = Long.MAX_VALUE;
            if (ComanalyzerPlugin.this.refresh_task != null) {
                ComanalyzerPlugin.this.refresh_task.cancel();
            }
            ComanalyzerPlugin.this.refresh_task = new RefreshTask(ComanalyzerPlugin.this, 1000L);
            ComanalyzerPlugin.this.timer.schedule((TimerTask)ComanalyzerPlugin.this.refresh_task, 1000L, 1000L);
            ComanalyzerPlugin.this.getJCC().setStatusText("Refresh Rate: 1 s (Auto Sensor)");
        }
    };

    public ComanalyzerPlugin() {
        this.listeners = new HashMap();
        this.componentlist = new ComponentList();
        this.agentfilter = new ComponentFilter[]{ComponentFilter.EMPTY};
        this.messagelist = new MessageList();
        this.messagefilter = new MessageFilter[]{MessageFilter.EMPTY};
        this.timer = new Timer(true);
        this.observed = new HashSet();
        this.paintmaps = new PaintMaps();
        this.msgservices = new HashMap();
        this.listener = new IRemoteMessageListener(){

            public IFuture messageReceived(IMessageAdapter msg) {
                ComanalyzerPlugin.this.addMessage(msg);
                return IFuture.DONE;
            }

            public IFuture messageSent(IMessageAdapter msg) {
                ComanalyzerPlugin.this.addMessage(msg);
                return IFuture.DONE;
            }
        };
    }

    public IFuture<Void> init(IControlCenter jcc) {
        final Future ret = new Future();
        super.init(jcc).addResultListener((IResultListener)new DelegationResultListener<Void>(ret){

            public void customResultAvailable(Void result) {
                SServiceProvider.getService((IExternalAccess)ComanalyzerPlugin.this.getJCC().getJCCAccess(), IClockService.class, (String)"platform").addResultListener((IResultListener)new SwingExceptionDelegationResultListener<IClockService, Void>(ret){

                    public void customResultAvailable(IClockService result) {
                        ComanalyzerPlugin.this.clockservice = result;
                        ret.setResult(null);
                    }
                });
            }
        });
        return ret;
    }

    public IFuture<Void> shutdown() {
        Future ret = new Future();
        this.comptree.dispose();
        CounterResultListener lis = new CounterResultListener(this.msgservices.values().size(), true, (IResultListener)new SwingDelegationResultListener(ret));
        for (Object[] entry : this.msgservices.values()) {
            ((IMessageService)entry[0]).removeMessageListener(this.listener).addResultListener((IResultListener)lis);
        }
        return ret;
    }

    public IFuture getProperties() {
        Properties props = new Properties();
        for (int i = 0; i < this.checkboxes.length; ++i) {
            props.addProperty(new Property(this.checkboxes[i].getText(), "" + this.checkboxes[i].isSelected()));
        }
        return new Future((Object)props);
    }

    public IFuture setProperties(Properties props) {
        for (int i = 0; i < this.checkboxes.length; ++i) {
            boolean selected = props.getBooleanProperty(this.checkboxes[i].getText());
            if (!selected) continue;
            this.checkboxes[i].doClick();
        }
        boolean selected = false;
        ToolTab[] tools = this.tpanel.tools;
        for (int i = 0; i < tools.length; ++i) {
            if (selected || !tools[i].isActive()) continue;
            this.tpanel.tabs.setSelectedIndex(i);
            selected = true;
        }
        return IFuture.DONE;
    }

    public String getName() {
        return "Comanalyzer";
    }

    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("comanalyzer_sel") : icons.getIcon("comanalyzer");
    }

    public JComponent[] createToolBar() {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        components.add(new JMenuButton(this.START_OBSERVING));
        components.add(new JMenuButton(this.STOP_OBSERVING));
        components.add(new JToolBar.Separator());
        components.add(new JMenuButton(this.LOAD_MESSAGES));
        components.add(new JMenuButton(this.SAVE_MESSAGES));
        components.add(new JToolBar.Separator());
        components.add(new JMenuButton(this.REMOVE_ALL));
        return components.toArray(new JComponent[components.size()]);
    }

    public JMenu[] createMenuBar() {
        ArrayList<JMenu> components = new ArrayList<JMenu>();
        JMenu m1 = new JMenu("Agents");
        m1.add(new JMenuItem(this.IGNORE_ALL));
        m1.add(new JMenuItem(this.OBSERVE_ALL));
        m1.add(new JCheckBoxMenuItem(this.OBSERVE_ALL_NEW));
        m1.addSeparator();
        m1.add(new JMenuItem(this.REMOVE_DEAD));
        JMenu m2 = new JMenu("Messages");
        m2.add(new JMenuItem(this.REMOVE_ALL_MESSAGES));
        JMenu m3 = new JMenu("Panels");
        m3.add(new JCheckBoxMenuItem(this.ENABLE_TABLE));
        m3.add(new JCheckBoxMenuItem(this.ENABLE_DIAGRAM));
        m3.add(new JCheckBoxMenuItem(this.ENABLE_GRAPH));
        m3.add(new JCheckBoxMenuItem(this.ENABLE_CHART));
        JMenu m4 = new JMenu("Auto Refresh");
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem refresh0 = new JRadioButtonMenuItem(this.REFRESH_ATONCE);
        refresh0.setSelected(this.sleep == Long.MIN_VALUE);
        group.add(refresh0);
        m4.add(refresh0);
        JRadioButtonMenuItem refresh1 = new JRadioButtonMenuItem(this.REFRESH_1S);
        refresh1.setSelected(this.sleep == 1000L);
        group.add(refresh1);
        m4.add(refresh1);
        JRadioButtonMenuItem refresh5 = new JRadioButtonMenuItem(this.REFRESH_5S);
        refresh5.setSelected(this.sleep == 5000L);
        group.add(refresh5);
        m4.add(refresh5);
        JRadioButtonMenuItem refreshA = new JRadioButtonMenuItem(this.REFRESH_AUTO);
        refreshA.setSelected(this.sleep == Long.MAX_VALUE);
        group.add(refreshA);
        m4.add(refreshA);
        components.add(m1);
        components.add(m2);
        components.add(m3);
        components.add(m4);
        ArrayList<JMenuItem> checkboxes = new ArrayList<JMenuItem>();
        for (JMenu menu : components) {
            for (int i = 0; i < menu.getItemCount(); ++i) {
                JMenuItem comp = menu.getItem(i);
                if (!(comp instanceof JCheckBoxMenuItem)) continue;
                checkboxes.add(comp);
            }
        }
        this.checkboxes = checkboxes.toArray(new JCheckBoxMenuItem[checkboxes.size()]);
        return components.toArray(new JMenu[components.size()]);
    }

    public JComponent createView() {
        this.split = new JSplitPane(1, true);
        this.split.setOneTouchExpandable(true);
        this.comptree = new ComponentTreePanel(this.getJCC().getPlatformAccess(), this.getJCC().getJCCAccess(), this.getJCC().getCMSHandler(), this.getJCC().getPropertyHandler(), this.getJCC().getIconCache());
        this.comptree.setMinimumSize(new Dimension(0, 0));
        this.split.add((java.awt.Component)this.comptree);
        this.comptree.getModel().addNodeListener(new INodeListener(){

            public void nodeAdded(ITreeNode node) {
                if (node instanceof IActiveComponentTreeNode) {
                    IComponentDescription ad = ((IActiveComponentTreeNode)node).getDescription();
                    ComanalyzerPlugin.this.agentBorn(ad);
                }
            }

            public void nodeRemoved(ITreeNode node) {
                if (node instanceof IActiveComponentTreeNode) {
                    IComponentDescription ad = ((IActiveComponentTreeNode)node).getDescription();
                    ComanalyzerPlugin.this.agentDied(ad);
                }
            }
        });
        this.comptree.addNodeHandler((ISwingNodeHandler)new AbstractJCCPlugin.ShowRemoteControlCenterHandler(this.getJCC(), (java.awt.Component)this.getView()));
        this.comptree.addNodeHandler(new ISwingNodeHandler(){

            public byte[] getOverlay(ITreeNode node) {
                return null;
            }

            public Icon getSwingOverlay(ISwingTreeNode node) {
                IComponentDescription ad;
                Component agent;
                Icon ret = null;
                if (node instanceof IActiveComponentTreeNode && (agent = ComanalyzerPlugin.this.componentlist.getAgent((ad = ((IActiveComponentTreeNode)node).getDescription()).getName())) != null && "observed".equals(agent.getState())) {
                    ret = icons.getIcon("agent_introspected");
                }
                return ret;
            }

            public Action[] getPopupActions(ISwingTreeNode[] nodes) {
                Action[] ret = null;
                boolean allcomp = true;
                for (int i = 0; allcomp && i < nodes.length; ++i) {
                    allcomp = nodes[i] instanceof IActiveComponentTreeNode;
                }
                if (allcomp) {
                    boolean allob = true;
                    for (int i = 0; allob && i < nodes.length; ++i) {
                        IComponentDescription ad = ((IActiveComponentTreeNode)nodes[i]).getDescription();
                        Component agent = ComanalyzerPlugin.this.componentlist.getAgent(ad.getName());
                        allob = agent != null && "observed".equals(agent.getState());
                    }
                    boolean allig = true;
                    for (int i = 0; allig && i < nodes.length; ++i) {
                        IComponentDescription ad = ((IActiveComponentTreeNode)nodes[i]).getDescription();
                        Component agent = ComanalyzerPlugin.this.componentlist.getAgent(ad.getName());
                        allig = agent != null && "ignored".equals(agent.getState());
                    }
                    if (allig) {
                        AbstractAction a = new AbstractAction((String)ComanalyzerPlugin.this.START_OBSERVING.getValue("Name"), icons.getIcon("start_observing")){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ComanalyzerPlugin.this.START_OBSERVING.actionPerformed(e);
                            }
                        };
                        ret = new Action[]{a};
                    } else if (allob) {
                        AbstractAction a = new AbstractAction((String)ComanalyzerPlugin.this.STOP_OBSERVING.getValue("Name"), icons.getIcon("stop_observing")){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ComanalyzerPlugin.this.STOP_OBSERVING.actionPerformed(e);
                            }
                        };
                        ret = new Action[]{a};
                    }
                }
                return ret;
            }

            public Action getDefaultAction(ISwingTreeNode node) {
                AbstractAction a = null;
                if (node instanceof IActiveComponentTreeNode) {
                    Component agent = ComanalyzerPlugin.this.componentlist.getAgent(((IActiveComponentTreeNode)node).getDescription().getName());
                    if (agent != null && agent.getState().equals("observed")) {
                        a = ComanalyzerPlugin.this.STOP_OBSERVING;
                    } else if (agent != null && agent.getState().equals("ignored")) {
                        a = ComanalyzerPlugin.this.START_OBSERVING;
                    }
                }
                return a;
            }
        });
        this.split.setDividerLocation(150);
        this.table = new TablePanel(this);
        this.diagram = new DiagramPanel(this);
        this.graph = new GraphPanel(this);
        this.chart = new ChartPanel(this);
        ToolTab[] tools = new ToolTab[]{this.table, this.diagram, this.graph, this.chart};
        for (int i = 0; i < tools.length; ++i) {
            this.componentlist.addListener(tools[i]);
            this.messagelist.addListener(tools[i]);
        }
        this.tpanel = new ToolPanel(tools);
        this.split.add(this.tpanel);
        Component dummy = Component.DUMMY_COMPONENT;
        this.applyAgentFilter(dummy);
        this.componentlist.addAgent(dummy);
        return this.split;
    }

    public void agentDied(final IComponentDescription ad) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component agent = ComanalyzerPlugin.this.componentlist.getAgent(ad.getName());
                agent.setState("dead");
                ComanalyzerPlugin.this.applyAgentFilter(agent);
            }
        });
    }

    public void agentBorn(final IComponentDescription ad) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean updateAgent = true;
                Component agent = ComanalyzerPlugin.this.componentlist.getAgent(ad.getName());
                if (agent == null) {
                    agent = new Component(ad);
                    updateAgent = false;
                }
                agent.setState(ComanalyzerPlugin.this.observe_all_new ? "observed" : "ignored");
                if (updateAgent) {
                    ComanalyzerPlugin.this.applyAgentFilter(agent);
                } else {
                    ComanalyzerPlugin.this.applyAgentFilter(agent);
                    ComanalyzerPlugin.this.componentlist.addAgent(agent);
                }
            }
        });
    }

    public void agentChanged(IComponentDescription ad) {
    }

    public MessageFilter[] getMessageFilter() {
        return this.messagefilter;
    }

    public void setMessageFilter(MessageFilter[] filter) {
        this.messagefilter = filter;
    }

    public void removeMessageFilter() {
        this.messagefilter = new MessageFilter[]{MessageFilter.EMPTY};
    }

    public void applyMessageFilter() {
        this.applyMessageFilter(this.messagelist.getMessages());
    }

    protected void applyMessageFilter(Message message) {
        this.applyMessageFilter(new Message[]{message});
    }

    protected void applyMessageFilter(Message[] messages) {
        ArrayList<Component> updated_components = new ArrayList<Component>();
        ArrayList<Message> updated_messages = new ArrayList<Message>();
        for (int i = 0; i < messages.length; ++i) {
            if (!messages[i].applyFilter(this.messagefilter)) continue;
            updated_messages.add(messages[i]);
            Component sender = messages[i].getSender();
            Component receiver = messages[i].getReceiver();
            if (sender.applyFilter(this.agentfilter, true) && !updated_components.contains(sender)) {
                updated_components.add(sender);
            }
            if (!receiver.applyFilter(this.agentfilter, true) || updated_components.contains(receiver)) continue;
            updated_components.add(receiver);
        }
        this.componentlist.fireAgentsChanged(updated_components.toArray(new Component[updated_components.size()]));
        this.messagelist.fireMessagesChanged(updated_messages.toArray(new Message[updated_messages.size()]));
    }

    public ComponentFilter[] getAgentFilter() {
        return this.agentfilter;
    }

    public void setAgentFilter(ComponentFilter[] filter) {
        this.agentfilter = filter;
    }

    public void removeAgentFilter() {
        ArrayList<ComponentFilter> filters = new ArrayList<ComponentFilter>();
        ComponentFilter[] afs = this.getAgentFilter();
        for (int i = 0; i < afs.length; ++i) {
            ComponentFilter af;
            if (afs[i].containsValue("state", "dummy")) {
                af = new ComponentFilter();
                af.addValue("state", "dummy");
                filters.add(afs[i]);
            }
            if (afs[i].containsValue("state", "ignored")) {
                af = new ComponentFilter();
                af.addValue("state", "ignored");
                filters.add(afs[i]);
            }
            if (afs[i].containsValue("state", "dead")) {
                af = new ComponentFilter();
                af.addValue("state", "dead");
                filters.add(afs[i]);
            }
            if (!afs[i].containsValue("message_visible", 0)) continue;
            af = new ComponentFilter();
            af.addValue("state", 0);
            filters.add(afs[i]);
        }
        this.agentfilter = filters.toArray(new ComponentFilter[filters.size()]);
    }

    public void applyAgentFilter() {
        this.applyAgentFilter(this.componentlist.getAgents());
    }

    protected void applyAgentFilter(Component agent) {
        this.applyAgentFilter(new Component[]{agent});
    }

    protected void applyAgentFilter(Component[] agents) {
        int i;
        ArrayList updated_components = new ArrayList();
        ArrayList updated_messages = new ArrayList();
        for (i = 0; i < agents.length; ++i) {
            agents[i].applyFilter(this.agentfilter, false);
            if (agents[i].equals(Component.DUMMY_COMPONENT) || agents[i].getMessages().size() <= 0) continue;
            if (agents[i].isVisible()) {
                Component.DUMMY_COMPONENT.getMessages().removeAll(agents[i].getMessages());
                continue;
            }
            Component.DUMMY_COMPONENT.getMessages().addAll(agents[i].getMessages());
        }
        for (i = 0; i < agents.length; ++i) {
            agents[i].applyFilter(this.agentfilter, true);
            if (agents[i].equals(Component.DUMMY_COMPONENT) || agents[i].getMessages().size() <= 0) continue;
            if (agents[i].isVisible()) {
                Component.DUMMY_COMPONENT.getMessages().removeAll(agents[i].getMessages());
                continue;
            }
            Component.DUMMY_COMPONENT.getMessages().addAll(agents[i].getMessages());
        }
        updated_components.addAll(this.componentlist.getList());
        updated_messages.addAll(this.messagelist.getList());
        this.componentlist.fireAgentsChanged(updated_components.toArray(new Component[updated_components.size()]));
        this.messagelist.fireMessagesChanged(updated_messages.toArray(new Message[updated_messages.size()]));
    }

    public MessageList getMessageList() {
        return this.messagelist;
    }

    public Message[] getMessages() {
        return this.messagelist.getMessages();
    }

    public Message getMessage(int messageNr) {
        return (Message)this.messagelist.getList().get(messageNr);
    }

    public ComponentList getAgentList() {
        return this.componentlist;
    }

    public Component[] getAgents() {
        return this.componentlist.getAgents();
    }

    public PaintMaps getPaintMaps() {
        return this.paintmaps;
    }

    protected void addMessage(final IMessageAdapter message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ComanalyzerPlugin.this.isAddMessage(message)) {
                    ArrayList<Message> messages_added = new ArrayList<Message>();
                    MessageType mt = message.getMessageType();
                    IComponentIdentifier sid = (IComponentIdentifier)message.getValue(mt.getSenderIdentifier());
                    Object recs = message.getValue(mt.getReceiverIdentifier());
                    if (recs instanceof IComponentIdentifier) {
                        IComponentIdentifier rid = (IComponentIdentifier)recs;
                        if (!ComanalyzerPlugin.this.isDuplicate(message, rid)) {
                            Message msg = ComanalyzerPlugin.this.createMessage(message, sid, rid);
                            messages_added.add(msg);
                        }
                    } else {
                        Iterator rids = SReflect.getIterator((Object)recs);
                        while (rids.hasNext()) {
                            IComponentIdentifier rid = (IComponentIdentifier)rids.next();
                            if (ComanalyzerPlugin.this.isDuplicate(message, rid)) continue;
                            Message msg = ComanalyzerPlugin.this.createMessage(message, sid, rid);
                            messages_added.add(msg);
                        }
                    }
                    if (!messages_added.isEmpty()) {
                        if (ComanalyzerPlugin.this.sleep != Long.MIN_VALUE && ComanalyzerPlugin.this.refresh_task != null) {
                            if (ComanalyzerPlugin.this.sleep == Long.MAX_VALUE) {
                                ComanalyzerPlugin.this.scheduleAutoRefresh();
                            }
                            ComanalyzerPlugin.this.refresh_task.fireMessagesAdded(messages_added.toArray(new Message[messages_added.size()]));
                        } else {
                            ComanalyzerPlugin.this.messagelist.fireMessagesAdded(messages_added.toArray(new Message[messages_added.size()]));
                        }
                    }
                }
            }
        });
    }

    protected boolean isDuplicate(IMessageAdapter newmsg, IComponentIdentifier rec) {
        boolean ret = false;
        Message[] messages = this.messagelist.getMessages();
        for (int i = 0; i < messages.length && !ret; ++i) {
            IComponentIdentifier oldrec;
            Object xid1 = messages[i].getParameter("x_message_id");
            Object xid2 = newmsg.getValue("x_message_id");
            if (xid1 == null || xid2 == null || !xid1.equals(xid2) || !(oldrec = (IComponentIdentifier)messages[i].getParameter("receiver")).equals(rec)) continue;
            String start = (String)messages[i].getParameter("x_timestamp");
            if (start != null) {
                long duration = this.clockservice.getTime() - Long.parseLong(start);
                messages[i].setDuration(duration);
            }
            ret = true;
        }
        return ret;
    }

    protected Message createMessage(IMessageAdapter msg, IComponentIdentifier sid, IComponentIdentifier rid) {
        Message message = new Message(msg, this.messagenr++, rid);
        message.applyFilter(this.messagefilter);
        this.messagelist.addMessage(message);
        Component sender = this.componentlist.getAgent(sid);
        if (sender == null) {
            sender = new Component((IComponentDescription)new CMSComponentDescription(sid, "unknown-component-type", false, false, false, false, false, null, null, null, null, -1L, null, null, false));
            sender.setState("dead");
            sender.addMessage(message);
            sender.applyFilter(this.agentfilter, true);
            this.componentlist.addAgent(sender);
        } else {
            sender.addMessage(message);
            this.applyAgentFilter(sender);
        }
        Component receiver = this.componentlist.getAgent(rid);
        if (receiver == null) {
            receiver = new Component((IComponentDescription)new CMSComponentDescription(rid, "unknown-component-type", false, false, false, false, false, null, null, null, null, -1L, null, null, false));
            receiver.setState("dead");
            receiver.addMessage(message);
            receiver.applyFilter(this.agentfilter, true);
            this.componentlist.addAgent(receiver);
        } else {
            receiver.addMessage(message);
            this.applyAgentFilter(receiver);
        }
        message.setSender(sender);
        message.setReceiver(receiver);
        this.paintmaps.createColor(message);
        return message;
    }

    protected void scheduleAutoRefresh() {
        int DURATION_FACTOR = 5;
        int AVERAGE_COUNT = 3;
        double PERIOD_TOLERANCE = 0.1;
        long REFRESH_LIMIT = 5000L;
        long period = 0L;
        period = this.refresh_task.getAverageExecutionDuration(3) != 0L ? this.refresh_task.getAverageExecutionDuration(3) * 5L : this.refresh_task.getPeriod();
        long l = period = period > 1000L ? period : 1000L;
        if (period > 5000L) {
            System.err.println("Cancel timer task with period : " + period);
            ToolTab[] tools = this.tpanel.tools;
            for (int i = 0; i < tools.length; ++i) {
                tools[i].setActive(false);
            }
            this.getJCC().setStatusText("Refresh Rate: Automatic OFF (Auto Sensor)");
        }
        if (period <= 5000L && period != this.refresh_task.getPeriod() && (double)(this.refresh_task.getPeriod() / Math.abs(period - this.refresh_task.getPeriod())) > 0.1) {
            System.err.println("New timer task with period : " + period);
            this.refresh_task.cancel();
            this.refresh_task = new RefreshTask(this, period, this.refresh_task.getDurations());
            this.timer.schedule((TimerTask)this.refresh_task, period, period);
            DecimalFormat df = new DecimalFormat("0.0");
            String rate = df.format((double)period / 1000.0);
            this.getJCC().setStatusText("Refresh Rate: " + rate + " s (Auto Sensor)");
        }
    }

    public boolean isAddMessage(IMessageAdapter msg) {
        MessageType mt = msg.getMessageType();
        String si = mt.getSenderIdentifier();
        IComponentIdentifier s = (IComponentIdentifier)msg.getValue(si);
        boolean add = false;
        if (this.observe_all_new || this.observed.contains(s)) {
            add = true;
        } else {
            String ris = mt.getReceiverIdentifier();
            Object rs = msg.getValue(ris);
            if (rs instanceof IComponentIdentifier) {
                if (this.observed.contains(rs)) {
                    add = true;
                }
            } else if (rs != null) {
                Iterator it = SReflect.getIterator((Object)rs);
                while (it.hasNext() && !add) {
                    if (!this.observed.contains(it.next())) continue;
                    add = true;
                }
            }
        }
        return add;
    }

    protected void addMessageListener(final List added) {
        final HashMap services = new HashMap();
        final CounterResultListener crl = new CounterResultListener(added.size(), true, (IResultListener)new SwingDefaultResultListener(){

            public void customResultAvailable(Object result) {
                for (IServiceIdentifier id : services.keySet()) {
                    Object[] newentry = (Object[])services.get(id);
                    Object[] oldentry = (Object[])ComanalyzerPlugin.this.msgservices.get(id);
                    if (oldentry != null && oldentry[1].equals(newentry[1])) continue;
                    if (oldentry != null) {
                        ((IMessageService)oldentry[0]).removeMessageListener(ComanalyzerPlugin.this.listener);
                    }
                    ComanalyzerPlugin.this.msgservices.put(id, newentry);
                    ((IMessageService)newentry[0]).addMessageListener(ComanalyzerPlugin.this.listener, ComanalyzerPlugin.this.createMessageFilter((Set)newentry[1]));
                }
            }
        });
        SServiceProvider.getService((IExternalAccess)this.jcc.getJCCAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new SwingDefaultResultListener(){

            public void customResultAvailable(Object result) {
                IComponentManagementService cms = (IComponentManagementService)result;
                for (int i = 0; i < added.size(); ++i) {
                    final Future fut = new Future();
                    fut.addResultListener((IResultListener)crl);
                    Component comp = (Component)added.get(i);
                    final IComponentIdentifier cid = comp.getDescription().getName();
                    cms.getExternalAccess(cid).addResultListener((IResultListener)new SwingDelegationResultListener(fut){

                        public void customResultAvailable(Object result) {
                            IExternalAccess ea = (IExternalAccess)result;
                            SServiceProvider.getService((IExternalAccess)ea, IMessageService.class, (String)"platform").addResultListener((IResultListener)new SwingDelegationResultListener(fut){

                                public void customResultAvailable(Object result) {
                                    Object[] newentry;
                                    IMessageService ms = (IMessageService)result;
                                    if (!services.containsKey(ms.getServiceIdentifier())) {
                                        if (ComanalyzerPlugin.this.msgservices.containsKey(ms.getServiceIdentifier())) {
                                            Object[] oldentry = (Object[])ComanalyzerPlugin.this.msgservices.get(ms.getServiceIdentifier());
                                            newentry = new Object[]{ms, new HashSet((Collection)oldentry[1])};
                                        } else {
                                            newentry = new Object[]{ms, new HashSet()};
                                        }
                                        services.put(ms.getServiceIdentifier(), newentry);
                                    } else {
                                        newentry = (Object[])services.get(ms.getServiceIdentifier());
                                    }
                                    ((Set)newentry[1]).add(cid);
                                    fut.setResult(null);
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    protected void removeMessageListener(List removed) {
        HashMap<IServiceIdentifier, Object[]> services = new HashMap<IServiceIdentifier, Object[]>();
        for (int i = 0; i < removed.size(); ++i) {
            IComponentIdentifier cid = ((Component)removed.get(i)).getDescription().getName();
            boolean found = false;
            Iterator it = this.msgservices.values().iterator();
            while (!found && it.hasNext()) {
                Object[] oldentry = (Object[])it.next();
                if (!((Set)oldentry[1]).contains(cid)) continue;
                found = true;
                IServiceIdentifier id = ((IMessageService)oldentry[0]).getServiceIdentifier();
                Object[] newentry = (Object[])services.get(id);
                if (newentry == null) {
                    newentry = new Object[]{oldentry[0], new HashSet((Collection)oldentry[1])};
                    services.put(id, newentry);
                }
                ((Set)newentry[1]).remove(cid);
            }
        }
        for (IServiceIdentifier id : services.keySet()) {
            Object[] newentry = (Object[])services.get(id);
            Object[] oldentry = (Object[])this.msgservices.get(id);
            if (oldentry != null) {
                ((IMessageService)oldentry[0]).removeMessageListener(this.listener);
                this.msgservices.remove(id);
            }
            if (((Set)newentry[1]).isEmpty()) continue;
            this.msgservices.put(id, newentry);
            ((IMessageService)newentry[0]).addMessageListener(this.listener, this.createMessageFilter((Set)newentry[1]));
        }
    }

    protected IFilter createMessageFilter(final Set agents) {
        return new IFilter(){

            @Classname(value="msgfilter")
            public boolean filter(Object obj) {
                Object recs;
                boolean ret = true;
                IMessageAdapter msg = (IMessageAdapter)obj;
                Object sender = msg.getValue(msg.getMessageType().getSenderIdentifier());
                if (!agents.contains(sender) && !agents.contains(recs = msg.getValue(msg.getMessageType().getReceiverIdentifier()))) {
                    ret = false;
                    if (SReflect.isIterable((Object)recs)) {
                        Iterator it = SReflect.getIterator((Object)recs);
                        while (!ret && it.hasNext()) {
                            ret = agents.contains(it.next());
                        }
                    }
                }
                return ret;
            }
        };
    }

    private class JMenuButton
    extends JButton {
        public JMenuButton(Action a) {
            super(a);
            this.setBorder(null);
            this.setToolTipText(this.getText());
            this.setText(null);
            this.setEnabled(true);
        }
    }
}

