/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.commons.ComposedFilter;
import jadex.commons.IFilter;
import jadex.tools.comanalyzer.ComponentFilter;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.ParameterElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Component
extends ParameterElement {
    public static final Component DUMMY_COMPONENT = new Component();
    public static final String DUMMY_NAME = "Dummy";
    public static final String STATE = "state";
    public static final String ID = "id";
    public static final String AID = "aid";
    public static final String DESCRIPTION = "desc";
    public static final String MESSAGE_COUNT = "message_count";
    public static final String MESSAGE_VISIBLE = "message_visible";
    public static final int NO_MESSAGES = 0;
    public static final String STATE_DEAD = "dead";
    public static final String STATE_OBSERVED = "observed";
    public static final String STATE_IGNORED = "ignored";
    public static final String STATE_DUMMY = "dummy";
    public static final String STATE_REMOTE = "remote";
    public static final List AGENT_ATTRIBUTES = new ArrayList();
    protected List messages = new ArrayList();

    public Component() {
        this(null);
        this.parameters.put(STATE, STATE_DUMMY);
        this.parameters.remove(MESSAGE_VISIBLE);
        this.parameters.remove(MESSAGE_COUNT);
    }

    public Component(IComponentDescription desc) {
        this.visible = true;
        this.parameters.put(ID, desc == null ? DUMMY_NAME : desc.getName().getName());
        this.parameters.put(AID, desc == null ? null : desc.getName());
        this.parameters.put(DESCRIPTION, desc);
        this.parameters.put(MESSAGE_COUNT, 0);
        this.parameters.put(MESSAGE_VISIBLE, 0);
        this.parameters.put("name", desc == null ? DUMMY_NAME : desc.getName().getName());
        this.parameters.put("class", Component.class.getSimpleName());
    }

    public static final String[] getDeclaredAttributes() {
        return AGENT_ATTRIBUTES.toArray(new String[AGENT_ATTRIBUTES.size()]);
    }

    @Override
    public Map getParameters() {
        if (!this.equals(DUMMY_COMPONENT)) {
            int msg_visible = 0;
            List msgs = this.getMessages();
            for (int i = 0; i < msgs.size(); ++i) {
                if (!((Message)msgs.get(i)).isVisible()) continue;
                if (DUMMY_COMPONENT.getMessages().contains(msgs.get(i))) {
                    if (!DUMMY_COMPONENT.isVisible()) continue;
                    ++msg_visible;
                    continue;
                }
                ++msg_visible;
            }
            this.parameters.put(MESSAGE_VISIBLE, msg_visible);
            this.parameters.put(MESSAGE_COUNT, this.messages.size());
        }
        return this.parameters;
    }

    @Override
    public Object getParameter(String name) {
        if (name.equals(MESSAGE_VISIBLE) || name.equals(MESSAGE_COUNT)) {
            return this.getParameters().get(name);
        }
        return this.parameters.get(name);
    }

    public IComponentDescription getDescription() {
        return (IComponentDescription)this.parameters.get(DESCRIPTION);
    }

    public String getState() {
        return (String)this.parameters.get(STATE);
    }

    public void setState(String state) {
        this.parameters.put(STATE, state);
    }

    public boolean applyFilter(ComponentFilter[] filter, boolean zeromessages) {
        boolean old = this.visible;
        ArrayList<ComponentFilter> filters = new ArrayList<ComponentFilter>();
        for (int i = 0; i < filter.length; ++i) {
            if (!filter[i].hasValues()) continue;
            if (zeromessages) {
                filters.add(filter[i]);
                continue;
            }
            if (filter[i].containsValue(MESSAGE_VISIBLE, 0)) continue;
            filters.add(filter[i]);
        }
        ComposedFilter ret = new ComposedFilter(filters.toArray(new IFilter[filters.size()]), 2);
        ret = new ComposedFilter(new IFilter[]{ret}, 3);
        try {
            this.visible = ret.filter((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return old != this.visible;
    }

    public List getMessages() {
        return this.messages;
    }

    public void setMessages(List messages) {
        this.messages = messages;
    }

    public void addMessage(Message message) {
        this.messages.add(message);
    }

    public void removeMessage(Message message) {
        this.messages.remove(message);
    }

    public void removeAllMessages() {
        this.messages.clear();
    }

    @Override
    public String getId() {
        return (String)this.parameters.get(ID);
    }

    @Override
    public int compareTo(Object o) {
        Component other = (Component)o;
        if (this == other || this.equals(other)) {
            return 0;
        }
        if (this.equals(DUMMY_COMPONENT)) {
            return -1;
        }
        if (o.equals(DUMMY_COMPONENT)) {
            return 1;
        }
        return this.getId().compareTo(other.getId());
    }

    @Override
    public String toString() {
        return "Agent(name=" + this.getId() + ")";
    }

    static {
        AGENT_ATTRIBUTES.add(ID);
        AGENT_ATTRIBUTES.add(AID);
        AGENT_ATTRIBUTES.add(DESCRIPTION);
        AGENT_ATTRIBUTES.add("name");
        AGENT_ATTRIBUTES.add(STATE);
        AGENT_ATTRIBUTES.add(MESSAGE_COUNT);
        AGENT_ATTRIBUTES.add(MESSAGE_VISIBLE);
    }
}

