/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import jadex.commons.SUtil;
import jadex.tools.comanalyzer.ComanalyzerPlugin;
import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.ComponentFilter;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.TitlePopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public class ComponentFilterMenu
extends TitlePopupMenu {
    protected ComanalyzerPlugin plugin;
    protected Component[] agents;
    protected boolean replacefilter = true;

    public ComponentFilterMenu(ComanalyzerPlugin plugin, Component agent) {
        this(plugin, new Component[]{agent});
    }

    public ComponentFilterMenu(ComanalyzerPlugin plugin, Component[] agents) {
        super("Agent Filter");
        this.plugin = plugin;
        this.agents = agents;
        this.createMenu();
    }

    protected void createMenu() {
        JMenuItem menu0 = new JMenuItem("Remove agent filter");
        menu0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentFilterMenu.this.plugin.removeAgentFilter();
                ComponentFilterMenu.this.plugin.applyAgentFilter();
            }
        });
        JMenuItem menu1 = new JMenuItem("Hide selected agents");
        menu1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentFilter filter = new ComponentFilter();
                for (int i = 0; i < ComponentFilterMenu.this.agents.length; ++i) {
                    if (ComponentFilterMenu.this.agents[i].equals(Component.DUMMY_COMPONENT)) continue;
                    filter.addValue("aid", ComponentFilterMenu.this.agents[i].getParameter("aid"));
                }
                List filters = SUtil.arrayToList((Object)ComponentFilterMenu.this.plugin.getAgentFilter());
                filters.add(filter);
                ComponentFilterMenu.this.plugin.setAgentFilter(filters.toArray(new ComponentFilter[filters.size()]));
                ComponentFilterMenu.this.plugin.applyAgentFilter();
            }
        });
        JMenuItem menu2 = new JMenuItem("Hide other agents");
        menu2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentFilter filter = new ComponentFilter();
                List other = SUtil.arrayToList((Object)ComponentFilterMenu.this.plugin.getAgents());
                other.removeAll(SUtil.arrayToList((Object)ComponentFilterMenu.this.agents));
                other.remove(Component.DUMMY_COMPONENT);
                for (int i = 0; i < other.size(); ++i) {
                    filter.addValue("aid", ((Component)other.get(i)).getParameter("aid"));
                }
                List filters = SUtil.arrayToList((Object)ComponentFilterMenu.this.plugin.getAgentFilter());
                filters.add(filter);
                ComponentFilterMenu.this.plugin.setAgentFilter(filters.toArray(new ComponentFilter[filters.size()]));
                ComponentFilterMenu.this.plugin.applyAgentFilter();
            }
        });
        JMenuItem menu3 = new JMenuItem("Show only this communicating group");
        menu3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComponentFilter filter = new ComponentFilter();
                ArrayList<Component> group = new ArrayList<Component>();
                for (int i = 0; i < ComponentFilterMenu.this.agents.length; ++i) {
                    List ms = ComponentFilterMenu.this.agents[i].getMessages();
                    for (int j = 0; j < ms.size(); ++j) {
                        group.add(((Message)ms.get(j)).getSender());
                        group.add(((Message)ms.get(j)).getReceiver());
                    }
                }
                List other = SUtil.arrayToList((Object)ComponentFilterMenu.this.plugin.getAgents());
                other.removeAll(group);
                other.remove(Component.DUMMY_COMPONENT);
                for (int i = 0; i < other.size(); ++i) {
                    filter.addValue("aid", ((Component)other.get(i)).getParameter("aid"));
                }
                List filters = SUtil.arrayToList((Object)ComponentFilterMenu.this.plugin.getAgentFilter());
                filters.add(filter);
                ComponentFilterMenu.this.plugin.setAgentFilter(filters.toArray(new ComponentFilter[filters.size()]));
                ComponentFilterMenu.this.plugin.applyAgentFilter();
            }
        });
        JMenuItem menu4 = new JMenuItem("Hide this communicating group");
        menu4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                ComponentFilter filter = new ComponentFilter();
                ArrayList<Component> group = new ArrayList<Component>();
                for (i = 0; i < ComponentFilterMenu.this.agents.length; ++i) {
                    List ms = ComponentFilterMenu.this.agents[i].getMessages();
                    for (int j = 0; j < ms.size(); ++j) {
                        group.add(((Message)ms.get(j)).getSender());
                        group.add(((Message)ms.get(j)).getReceiver());
                    }
                }
                for (i = 0; i < group.size(); ++i) {
                    filter.addValue("aid", ((Component)group.get(i)).getParameter("aid"));
                }
                List filters = SUtil.arrayToList((Object)ComponentFilterMenu.this.plugin.getAgentFilter());
                filters.add(filter);
                ComponentFilterMenu.this.plugin.setAgentFilter(filters.toArray(new ComponentFilter[filters.size()]));
                ComponentFilterMenu.this.plugin.applyAgentFilter();
            }
        });
        this.add(menu0);
        this.addSeparator();
        this.add(menu1);
        this.add(menu2);
        this.addSeparator();
        this.add(menu3);
        this.add(menu4);
        boolean disabled = this.agents.length == 1 && this.agents[0].equals(Component.DUMMY_COMPONENT);
        menu1.setEnabled(!disabled);
        menu2.setEnabled(!disabled);
        menu3.setEnabled(!disabled);
        menu4.setEnabled(!disabled);
    }
}

