/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import jadex.bridge.IComponentIdentifier;
import jadex.commons.SUtil;
import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.IComponentListListener;
import jadex.tools.comanalyzer.IMessageListListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ComponentList
implements Serializable {
    private List elements;
    private List listeners = new ArrayList();

    public ComponentList() {
        this.elements = new ArrayList();
    }

    public void addAgent(Component agent) {
        if (this.elements.contains(agent)) {
            return;
        }
        this.elements.add(agent);
        this.fireAgentsAdded(new Component[]{agent});
    }

    public void removeAgent(Component agent) {
        this.elements.remove(agent);
        this.fireAgentsRemoved(new Component[]{agent});
    }

    public void removeAllAgents() {
        Component[] agents = this.elements.toArray(new Component[this.elements.size()]);
        this.elements.clear();
        this.fireAgentsRemoved(agents);
    }

    public List getList() {
        return this.elements;
    }

    public Component[] getAgents() {
        return this.elements.toArray(new Component[this.elements.size()]);
    }

    public boolean containsAgent(Component agent) {
        return this.elements.contains(agent);
    }

    public Component getAgent(IComponentIdentifier aid) {
        for (Component original : this.elements) {
            if (!SUtil.equals((Object)(original.getDescription() != null ? original.getDescription().getName() : null), (Object)aid)) continue;
            return original;
        }
        return null;
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    public int size() {
        return this.elements.size();
    }

    protected void addListener(IComponentListListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            listener.componentsAdded(this.elements.toArray(new Component[this.elements.size()]));
        }
    }

    protected void fireAgentsRemoved(Component[] agents) {
        if (agents != null) {
            for (IMessageListListener listener : this.listeners) {
                ((IComponentListListener)((Object)listener)).componentsRemoved(agents);
            }
        }
    }

    protected void fireAgentsAdded(Component[] agents) {
        if (agents != null) {
            for (IMessageListListener listener : this.listeners) {
                ((IComponentListListener)((Object)listener)).componentsAdded(agents);
            }
        }
    }

    protected void fireAgentsChanged(Component[] agents) {
        if (agents != null) {
            for (IMessageListListener listener : this.listeners) {
                ((IComponentListListener)((Object)listener)).componentsChanged(agents);
            }
        }
    }
}

