/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import jadex.commons.IFilter;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.collection.IndexMap;
import jadex.commons.collection.SCollection;
import java.io.Serializable;
import java.util.Map;

public class ComposedFilter
implements IFilter,
Serializable {
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int NOT = 3;
    protected IFilter[] filters;
    protected int operator;

    public ComposedFilter(IFilter[] filters, int operator) {
        this.filters = filters;
        this.operator = operator;
    }

    public boolean filter(Object object) {
        boolean ret = false;
        if (this.operator == 1) {
            ret = true;
            for (int i = 0; i < this.filters.length && ret; ++i) {
                ret = ret && this.filters[i].filter(object);
            }
        } else if (this.operator == 2) {
            RuntimeException exception = null;
            for (int i = 0; i < this.filters.length && !ret; ++i) {
                try {
                    ret = ret || this.filters[i].filter(object);
                    continue;
                }
                catch (RuntimeException e) {
                    exception = exception != null ? exception : e;
                }
            }
            if (!ret && exception != null) {
                throw exception;
            }
        } else if (this.operator == 3) {
            ret = !this.filters[0].filter(object);
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(operator=");
        sb.append(ComposedFilter.operatorToString(this.operator));
        sb.append(", filters=");
        sb.append(SUtil.arrayToString((Object)this.filters));
        sb.append(")");
        return sb.toString();
    }

    public static String operatorToString(int operator) {
        switch (operator) {
            case 1: {
                return "AND";
            }
            case 2: {
                return "OR";
            }
            case 3: {
                return "NOT";
            }
        }
        throw new RuntimeException("Unknown operator: " + operator);
    }

    public Map getEncodableRepresentation() {
        IndexMap representation = SCollection.createIndexMap();
        representation.add((Object)"isencodeablepresentation", (Object)"true");
        representation.add((Object)"class", (Object)"ComposedFilter");
        representation.add((Object)"operator", (Object)ComposedFilter.operatorToString(this.operator));
        representation.add((Object)"filters", (Object)SUtil.arrayToString((Object)this.filters));
        return representation.getAsMap();
    }
}

