/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import edu.uci.ics.jung.graph.util.Pair;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IMessageAdapter;
import jadex.commons.ComposedFilter;
import jadex.commons.IFilter;
import jadex.commons.collection.SCollection;
import jadex.tools.comanalyzer.Component;
import jadex.tools.comanalyzer.MessageFilter;
import jadex.tools.comanalyzer.ParameterElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Message
extends ParameterElement {
    public static final String SEQ_NO = "seq-no";
    public static final String XID = "x_message_id";
    public static final String DATE = "x_timestamp";
    public static final String DURATION = "duration";
    public static final String SENDER = "sender";
    public static final String RECEIVER = "receiver";
    public static final String RECEIVERS = "receivers";
    public static final String PERFORMATIVE = "performative";
    public static final String CONTENT = "content";
    public static final String ONTOLOGY = "ontology";
    public static final String ENCODING = "encoding";
    public static final String IN_REPLY_TO = "in_reply_to";
    public static final String LANGUAGE = "language";
    public static final String PROTOCOL = "protocol";
    public static final String REPLY_BY = "reply_by";
    public static final String REPLY_WITH = "reply_with";
    public static final String REPLY_TO = "reply_to";
    public static final String CONVERSATION_ID = "conversation_id";
    public static final List MESSAGE_ATTRIBUTES = new ArrayList();
    protected Component sender;
    protected Component receiver;
    protected int uniqueId;
    protected IMessageAdapter message;

    public Message() {
    }

    public Message(IMessageAdapter msg, int sequence, IComponentIdentifier receiver) {
        assert (receiver != null);
        this.uniqueId = sequence;
        this.message = msg;
        this.parameters.put(SEQ_NO, sequence);
        this.parameters.put("name", this.message.getParameterMap().get(XID));
        this.parameters.put("class", Message.class.getSimpleName());
        this.parameters.put(RECEIVER, receiver);
    }

    public static final String[] getDeclaredParameters() {
        return MESSAGE_ATTRIBUTES.toArray(new String[MESSAGE_ATTRIBUTES.size()]);
    }

    public Component getSender() {
        return this.sender;
    }

    public Component getReceiver() {
        return this.receiver;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    public boolean isMulticast() {
        IComponentIdentifier[] aids = (IComponentIdentifier[])this.getParameter(RECEIVERS);
        return aids.length > 1;
    }

    public Pair getEndpoints() {
        if (!this.isVisible()) {
            return null;
        }
        Component sender = this.getSender();
        Component receiver = this.getReceiver();
        if (sender.isVisible() && receiver.isVisible()) {
            return new Pair((Object)sender, (Object)receiver);
        }
        if (Component.DUMMY_COMPONENT.isVisible() && sender.isVisible() ^ receiver.isVisible()) {
            sender = sender.isVisible() ? sender : Component.DUMMY_COMPONENT;
            receiver = receiver.isVisible() ? receiver : Component.DUMMY_COMPONENT;
            return new Pair((Object)sender, (Object)receiver);
        }
        return null;
    }

    protected boolean applyFilter(MessageFilter[] filter) {
        IFilter ret;
        boolean old = this.visible;
        ArrayList filters = SCollection.createArrayList();
        for (int i = 0; i < filter.length; ++i) {
            if (!filter[i].hasValues()) continue;
            filters.add(filter[i]);
        }
        if (filters.size() == 1) {
            ret = (IFilter)filters.get(0);
        } else if (filters.size() > 1) {
            ret = new ComposedFilter(filters.toArray(new IFilter[filters.size()]), 1);
        } else {
            this.visible = true;
            return old != this.visible;
        }
        try {
            this.visible = ret.filter((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return old != this.visible;
    }

    public void setSender(Component agent) {
        this.sender = agent;
    }

    public void setReceiver(Component agent) {
        this.receiver = agent;
    }

    public void setDuration(long duration) {
        this.setParameter(DURATION, duration);
    }

    @Override
    public String getId() {
        return (String)this.getParameter(XID);
    }

    @Override
    public Object getParameter(String name) {
        Object ret = super.getParameter(name);
        if (ret == null && this.message != null) {
            ret = this.message.getValue(name);
        }
        return ret;
    }

    @Override
    public Map getParameters() {
        HashMap ret = new HashMap();
        ret.putAll(this.parameters);
        if (this.message != null) {
            ret.putAll(this.message.getParameterMap());
        }
        return ret;
    }

    @Override
    public boolean hasParameter(String name) {
        boolean ret = this.parameters.containsKey(name);
        if (!ret) {
            ret = this.message.getParameterMap().containsKey(name);
        }
        return ret;
    }

    @Override
    public int compareTo(Object o) {
        Message other = (Message)o;
        return this.uniqueId - other.uniqueId;
    }

    public int hashCode() {
        return this.uniqueId;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Message && this.uniqueId == ((Message)obj).uniqueId;
    }

    @Override
    public String toString() {
        return "Message(id=" + this.getId() + ")";
    }

    static {
        MESSAGE_ATTRIBUTES.add(SEQ_NO);
        MESSAGE_ATTRIBUTES.add(XID);
        MESSAGE_ATTRIBUTES.add(DATE);
        MESSAGE_ATTRIBUTES.add(DURATION);
        MESSAGE_ATTRIBUTES.add(SENDER);
        MESSAGE_ATTRIBUTES.add(RECEIVER);
        MESSAGE_ATTRIBUTES.add(RECEIVERS);
        MESSAGE_ATTRIBUTES.add(PERFORMATIVE);
        MESSAGE_ATTRIBUTES.add(CONVERSATION_ID);
        MESSAGE_ATTRIBUTES.add(ONTOLOGY);
        MESSAGE_ATTRIBUTES.add(PROTOCOL);
        MESSAGE_ATTRIBUTES.add(CONTENT);
        MESSAGE_ATTRIBUTES.add(ENCODING);
        MESSAGE_ATTRIBUTES.add(IN_REPLY_TO);
        MESSAGE_ATTRIBUTES.add(LANGUAGE);
        MESSAGE_ATTRIBUTES.add(REPLY_BY);
        MESSAGE_ATTRIBUTES.add(REPLY_WITH);
        MESSAGE_ATTRIBUTES.add(REPLY_TO);
    }
}

