/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import jadex.commons.SUtil;
import jadex.tools.comanalyzer.ComanalyzerPlugin;
import jadex.tools.comanalyzer.Message;
import jadex.tools.comanalyzer.MessageFilter;
import jadex.tools.comanalyzer.TitlePopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;

public class MessageFilterMenu
extends TitlePopupMenu {
    protected static final String[] default_parameters = new String[]{"conversation_id", "protocol", "performative"};
    protected static final String[] extended_parameters = new String[]{"x_message_id", "sender", "receiver", "in_reply_to", "reply_to", "reply_with", "reply_by", "content", "ontology", "encoding", "language"};
    protected ComanalyzerPlugin plugin;
    protected Message[] messages;
    protected boolean replacefilter = true;

    public MessageFilterMenu(ComanalyzerPlugin plugin, Message message) {
        this(plugin, new Message[]{message});
    }

    public MessageFilterMenu(ComanalyzerPlugin plugin, Message[] messages) {
        super("Message Filter");
        this.plugin = plugin;
        this.messages = messages;
        this.createMenu();
    }

    protected void createMenu() {
        JMenuItem menu0 = new JMenuItem("Remove message filter");
        menu0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageFilterMenu.this.plugin.removeMessageFilter();
                MessageFilterMenu.this.plugin.applyMessageFilter();
            }
        });
        this.add(menu0);
        this.addSeparator();
        JMenuItem menu1 = new JMenuItem("Show only messages between participants");
        menu1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageFilter filter = new MessageFilter();
                for (int i = 0; i < MessageFilterMenu.this.messages.length; ++i) {
                    filter.addValue("sender", MessageFilterMenu.this.messages[i].getParameter("sender"));
                    filter.addValue("sender", MessageFilterMenu.this.messages[i].getParameter("receiver"));
                    filter.addValue("receiver", MessageFilterMenu.this.messages[i].getParameter("receiver"));
                    filter.addValue("receiver", MessageFilterMenu.this.messages[i].getParameter("sender"));
                }
                MessageFilterMenu.this.plugin.setMessageFilter(new MessageFilter[]{filter});
                MessageFilterMenu.this.plugin.applyMessageFilter();
            }
        });
        this.add(menu1);
        JMenuItem menu2 = new JMenuItem("Show only selected messages");
        menu2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageFilter filter = new MessageFilter();
                for (int i = 0; i < MessageFilterMenu.this.messages.length; ++i) {
                    filter.addValue("seq-no", MessageFilterMenu.this.messages[i].getParameter("seq-no"));
                }
                MessageFilterMenu.this.plugin.setMessageFilter(new MessageFilter[]{filter});
                MessageFilterMenu.this.plugin.applyMessageFilter();
            }
        });
        if (this.messages.length > 1) {
            this.add(menu2);
        }
        this.addSeparator();
        JCheckBoxMenuItem addfilter = new JCheckBoxMenuItem("Replace filter");
        addfilter.setSelected(true);
        addfilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)e.getSource();
                MessageFilterMenu.this.replacefilter = checkbox.isSelected();
                MessageFilterMenu.this.setVisible(true);
            }
        });
        this.add(addfilter);
        this.addParameterMenuItems(default_parameters);
        this.addSeparator();
        JMenuItem extend = new JMenuItem("Extend...");
        extend.setFont(this.getFont().deriveFont(this.getFont().getStyle() + 2));
        extend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                item.setVisible(false);
                MessageFilterMenu.this.addParameterMenuItems(extended_parameters);
                MessageFilterMenu.this.setVisible(true);
            }
        });
        this.add(extend);
    }

    private void addParameterMenuItems(String[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            HashSet<Object> valueset = new HashSet<Object>();
            for (int j = 0; j < this.messages.length; ++j) {
                valueset.add(this.messages[j].getParameter(parameters[i]));
            }
            Object[] values = valueset.toArray(new Object[valueset.size()]);
            KeyMenuItem item = valueset.size() == 1 ? new KeyMenuItem(parameters[i], values[0]) : new KeyMenuItem(parameters[i]);
            this.add(item);
        }
    }

    private class KeyMenuItem
    extends JMenuItem {
        public KeyMenuItem(String key) {
            super(key + ": more than one value");
            this.setEnabled(false);
        }

        public KeyMenuItem(final String key, final Object value) {
            super(key + ": " + value);
            String name = key + ": " + value;
            this.setAction(new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MessageFilter[] fil;
                    MessageFilter filter = new MessageFilter();
                    filter.addValue(key, value);
                    if (MessageFilterMenu.this.replacefilter) {
                        fil = new MessageFilter[]{filter};
                    } else {
                        List list = SUtil.arrayToList((Object)MessageFilterMenu.this.plugin.getMessageFilter());
                        list.add(filter);
                        fil = list.toArray(new MessageFilter[list.size()]);
                    }
                    MessageFilterMenu.this.plugin.setMessageFilter(fil);
                    MessageFilterMenu.this.plugin.applyMessageFilter();
                }
            });
        }
    }
}

