/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.comanalyzer;

import jadex.commons.SUtil;
import jadex.commons.collection.SortedList;
import jadex.tools.comanalyzer.IMessageListListener;
import jadex.tools.comanalyzer.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MessageList
implements Iterable,
Serializable {
    protected List elements = new SortedList();
    protected List listeners = new ArrayList();

    public void addMessage(Message msg) {
        this.elements.add(msg);
    }

    public void addMessages(Message[] messages) {
        this.elements.addAll(SUtil.arrayToList((Object)messages));
    }

    public void removeMessage(Message msg) {
        this.elements.remove(msg);
    }

    public void removeMessages(Message[] messages) {
        this.elements.removeAll(SUtil.arrayToList((Object)messages));
    }

    public void removeAllMessages() {
        Message[] messages = this.elements.toArray(new Message[this.elements.size()]);
        this.elements.clear();
        this.fireMessagesRemoved(messages);
    }

    public boolean containsMessage(Message message) {
        return this.elements.contains(message);
    }

    public Message[] getMessages() {
        return this.elements.toArray(new Message[0]);
    }

    public List getList() {
        return this.elements;
    }

    public int size() {
        return this.elements.size();
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    protected void addListener(IMessageListListener ml) {
        if (!this.listeners.contains(ml)) {
            this.listeners.add(ml);
            ml.messagesAdded(this.getMessages());
        }
    }

    protected void fireMessagesAdded(Message[] messages) {
        if (messages != null) {
            for (IMessageListListener listener : this.listeners) {
                listener.messagesAdded(messages);
            }
        }
    }

    protected void fireMessagesRemoved(Message[] messages) {
        for (IMessageListListener listener : this.listeners) {
            listener.messagesRemoved(messages);
        }
    }

    protected void fireMessagesChanged(Message[] messages) {
        for (IMessageListListener listener : this.listeners) {
            listener.messagesChanged(messages);
        }
    }
}

